/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpRequest;
import com.google.auth.CredentialTypeForMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class MetricsUtils {
    static final String API_CLIENT_HEADER = "x-goog-api-client";
    static final String CRED_TYPE = "cred-type";
    static final String AUTH_REQUEST_TYPE = "auth-request-type";
    private static final String authLibraryVersion = MetricsUtils.getAuthLibraryVersion();
    private static final String javaLanguageVersion = System.getProperty("java.version");

    MetricsUtils() {
    }

    static String getLanguageAndAuthLibraryVersions() {
        return String.format("gl-java/%s auth/%s", javaLanguageVersion, authLibraryVersion);
    }

    private static String getAuthLibraryVersion() {
        String version = "unknown-version";
        try (InputStream inputStream2 = MetricsUtils.class.getResourceAsStream("/com/google/auth/oauth2/google-auth-library.properties");){
            if (inputStream2 != null) {
                Properties properties = new Properties();
                properties.load(inputStream2);
                version = properties.getProperty("google-auth-library.version");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    static String getGoogleCredentialsMetricsHeader(RequestType requestType, CredentialTypeForMetrics credentialTypeForMetrics) {
        StringBuilder stringBuilder = new StringBuilder(MetricsUtils.getLanguageAndAuthLibraryVersions());
        if (requestType != RequestType.UNTRACKED) {
            stringBuilder.append(String.format(" %s/%s", AUTH_REQUEST_TYPE, requestType.getLabel()));
        }
        if (credentialTypeForMetrics != CredentialTypeForMetrics.DO_NOT_SEND) {
            stringBuilder.append(String.format(" %s/%s", CRED_TYPE, credentialTypeForMetrics.getLabel()));
        }
        return stringBuilder.toString();
    }

    static void setMetricsHeader(HttpRequest request, String metricsHeader) {
        request.getHeaders().set(API_CLIENT_HEADER, metricsHeader);
    }

    public static enum RequestType {
        ACCESS_TOKEN_REQUEST("at"),
        ID_TOKEN_REQUEST("it"),
        METADATA_SERVER_PING("mds"),
        UNTRACKED("untracked");

        private final String label;

        private RequestType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

