/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.base.Verify;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.auto.value.processor.TypeEncoder;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class Optionalish {
    private static final ImmutableSet<String> OPTIONAL_CLASS_NAMES = ImmutableSet.of("com.".concat("google.common.base.Optional"), "java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong");
    private final DeclaredType optionalType;
    private final String className;
    private static final ImmutableMap<String, TypeKind> PRIMITIVE_TYPE_KINDS = ImmutableMap.of("OptionalDouble", TypeKind.DOUBLE, "OptionalInt", TypeKind.INT, "OptionalLong", TypeKind.LONG);

    private Optionalish(DeclaredType optionalType) {
        this.optionalType = optionalType;
        this.className = MoreElements.asType(optionalType.asElement()).getQualifiedName().toString();
    }

    static Optionalish createIfOptional(TypeMirror type) {
        if (Optionalish.isOptional(type)) {
            return new Optionalish(MoreTypes.asDeclared(type));
        }
        return null;
    }

    static boolean isOptional(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = MoreTypes.asDeclared(type);
        TypeElement typeElement = MoreElements.asType(declaredType.asElement());
        return OPTIONAL_CLASS_NAMES.contains(typeElement.getQualifiedName().toString()) && typeElement.getTypeParameters().size() == declaredType.getTypeArguments().size();
    }

    public String getRawType() {
        return TypeEncoder.encodeRaw(this.optionalType);
    }

    public String getEmpty() {
        String empty = this.className.startsWith("java.util.") ? ".empty()" : ".absent()";
        return TypeEncoder.encodeRaw(this.optionalType) + empty;
    }

    TypeMirror getContainedType(Types typeUtils) {
        List<? extends TypeMirror> typeArguments = this.optionalType.getTypeArguments();
        switch (typeArguments.size()) {
            case 1: {
                return typeArguments.get(0);
            }
            case 0: {
                return this.getContainedPrimitiveType(typeUtils);
            }
        }
        throw new AssertionError((Object)("Wrong number of type arguments: " + this.optionalType));
    }

    String ofNullable() {
        return this.className.equals("java.util.Optional") ? "ofNullable" : "fromNullable";
    }

    private TypeMirror getContainedPrimitiveType(Types typeUtils) {
        String simpleName = this.optionalType.asElement().getSimpleName().toString();
        TypeKind typeKind = PRIMITIVE_TYPE_KINDS.get(simpleName);
        Verify.verifyNotNull(typeKind, "Could not get contained type of %s", this.optionalType);
        return typeUtils.getPrimitiveType(typeKind);
    }
}

