/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.genai.ApiClient;
import com.google.genai.AsyncSession;
import com.google.genai.Common;
import com.google.genai.JsonSerializable;
import com.google.genai.LiveConverters;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.LiveConnectConfig;
import com.google.genai.types.LiveConnectParameters;
import com.google.genai.types.LiveServerMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class AsyncLive {
    private final ApiClient apiClient;

    AsyncLive(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CompletableFuture<AsyncSession> connect(String model, LiveConnectConfig config) {
        CompletableFuture<AsyncSession> future = new CompletableFuture<AsyncSession>();
        GenAiWebSocketClient websocket = new GenAiWebSocketClient(this.getWebSocketUri(), this.getWebSocketHeaders(), this.getSetupRequest(model, config), future, this.apiClient);
        websocket.connect();
        return future;
    }

    private URI getWebSocketUri() {
        String baseUrl = this.apiClient.httpOptions.baseUrl().orElse(null);
        if (baseUrl == null) {
            throw new IllegalArgumentException("No base URL provided in the client.");
        }
        try {
            URI baseUri = new URI(baseUrl);
            String wsBaseUrl = new URI("wss", baseUri.getAuthority(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment()).toString();
            if (!this.apiClient.vertexAI()) {
                return new URI(String.format("%s/ws/google.ai.generativelanguage.%s.GenerativeService.BidiGenerateContent?key=%s", wsBaseUrl, this.apiClient.httpOptions.apiVersion().orElse("v1beta"), this.apiClient.apiKey()));
            }
            return new URI(String.format("%s/ws/google.cloud.aiplatform.%s.LlmBidiService/BidiGenerateContent", wsBaseUrl, this.apiClient.httpOptions.apiVersion().orElse("v1beta1")));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to parse URL.", e);
        }
    }

    private Map<String, String> getWebSocketHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.httpOptions.headers().ifPresent(headers::putAll);
        if (this.apiClient.vertexAI()) {
            try {
                GoogleCredentials credentials = this.apiClient.credentials.orElse(this.apiClient.defaultCredentials());
                credentials.refreshIfExpired();
                headers.put("Authorization", "Bearer " + credentials.getAccessToken().getTokenValue());
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials for Vertex AI.", e);
            }
        }
        return headers;
    }

    private String getSetupRequest(String model, LiveConnectConfig config) {
        String transformedModel = Transformers.tModel(this.apiClient, model);
        if (this.apiClient.vertexAI() && transformedModel.startsWith("publishers/")) {
            model = String.format("projects/%s/locations/%s/%s", this.apiClient.project(), this.apiClient.location(), transformedModel);
        }
        LiveConverters liveConverters = new LiveConverters(this.apiClient);
        LiveConnectParameters.Builder parameterBuilder = LiveConnectParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        ObjectNode body = this.apiClient.vertexAI() ? liveConverters.liveConnectParametersToVertex(this.apiClient, parameterNode, null) : liveConverters.liveConnectParametersToMldev(this.apiClient, parameterNode, null);
        body.remove("config");
        return JsonSerializable.toJsonString(body);
    }

    static class GenAiWebSocketClient
    extends WebSocketClient {
        private final String setupRequest;
        private final CompletableFuture<AsyncSession> sessionFuture;
        private final ApiClient apiClient;
        private Consumer<LiveServerMessage> messageCallback;

        public GenAiWebSocketClient(URI uri, Map<String, String> headers, String setupRequest, CompletableFuture<AsyncSession> sessionFuture, ApiClient apiClient) {
            super(uri, headers);
            this.setupRequest = setupRequest;
            this.sessionFuture = sessionFuture;
            this.messageCallback = null;
            this.apiClient = apiClient;
        }

        public void setMessageCallback(Consumer<LiveServerMessage> messageCallback) {
            this.messageCallback = messageCallback;
        }

        @Override
        public void onOpen(ServerHandshake handshake2) {
            this.send(this.setupRequest);
        }

        @Override
        public void onMessage(String message) {
            this.handleIncomingMessage(message);
        }

        @Override
        public void onMessage(ByteBuffer message) {
            try {
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                CharBuffer charBuffer = decoder.decode(message);
                this.handleIncomingMessage(charBuffer.toString());
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException("Invalid UTF-8 message received from the live session.", e);
            }
        }

        @Override
        public void onError(Exception ex) {
            System.err.println("Error during live session: " + ex.getMessage());
            ex.printStackTrace();
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.completeExceptionally(ex);
            }
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            System.out.println("Live session closed with code: " + code + " and reason: " + reason);
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.completeExceptionally(new GenAiIOException("WebSocket closed unexpectedly: " + reason));
            }
        }

        private void handleIncomingMessage(String message) {
            if (!this.sessionFuture.isDone()) {
                this.sessionFuture.complete(new AsyncSession(this.apiClient, this));
                return;
            }
            if (this.messageCallback != null) {
                try {
                    LiveServerMessage serverMessage = LiveServerMessage.fromJson(message);
                    this.messageCallback.accept(serverMessage);
                }
                catch (RuntimeException e) {
                    System.err.println("Error deserializing message: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("Received message from live session but no callback registered! Please call `AsyncSession.receive()` to register a callback.");
            }
        }
    }
}

