/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.genai.BasePager;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncPager<T extends JsonSerializable>
extends BasePager<T> {
    private final Function<JsonSerializable, CompletableFuture<JsonNode>> asyncRequest;
    private final CompletableFuture<Void> initializationFuture;

    AsyncPager(BasePager.PagedItem pagedItem, Function<JsonSerializable, CompletableFuture<JsonNode>> asyncRequest, ObjectNode requestConfig, CompletableFuture<JsonNode> responseFuture) {
        super(pagedItem, requestConfig);
        this.asyncRequest = asyncRequest;
        this.initializationFuture = ((CompletableFuture)responseFuture.thenAccept(response -> this.initNewPage((JsonNode)response))).exceptionally(e -> {
            throw new GenAiIOException("Failed to process initial page for AsyncPager: " + e.getMessage());
        });
    }

    public CompletableFuture<ImmutableList<T>> nextPage() {
        return this.hasNextPage().thenCompose(hasNext -> {
            if (!hasNext.booleanValue()) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(new IndexOutOfBoundsException("No more page in the async pager."));
                return failedFuture;
            }
            try {
                return this.asyncRequest.apply(JsonSerializable.fromJsonNode(this.requestConfig, this.pagedItem.requestConfigClass())).thenApply(response -> {
                    this.initNewPage((JsonNode)response);
                    return this.page;
                });
            }
            catch (Exception e) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(new GenAiIOException("Failed to fetch the next page. " + e.getMessage()));
                return failedFuture;
            }
        });
    }

    CompletableFuture<Boolean> hasNextPage() {
        return this.initializationFuture.thenApply(v -> this.requestConfig.get("pageToken") != null);
    }

    public CompletableFuture<Void> forEach(Consumer<? super T> itemAction) {
        if (itemAction == null) {
            CompletableFuture<Void> failedFuture = new CompletableFuture<Void>();
            failedFuture.completeExceptionally(new IllegalArgumentException("Action cannot be null."));
            return failedFuture;
        }
        return this.initializationFuture.thenCompose(v -> this.processPageItemsAndContinue(this.page, itemAction));
    }

    private CompletableFuture<Void> processPageItemsAndContinue(ImmutableList<T> page, Consumer<? super T> itemAction) {
        for (JsonSerializable item : page) {
            try {
                itemAction.accept(item);
            }
            catch (Exception e) {
                CompletableFuture<Void> failedFuture = new CompletableFuture<Void>();
                failedFuture.completeExceptionally(new GenAiIOException("Failed to process item. " + e.getMessage()));
                return failedFuture;
            }
        }
        return this.hasNextPage().thenCompose(hasNext -> {
            if (hasNext.booleanValue()) {
                return this.nextPage().thenCompose(nextPageItems -> this.processPageItemsAndContinue((ImmutableList<T>)nextPageItems, itemAction));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<ImmutableList<T>> page() {
        return this.initializationFuture.thenApply(v -> this.page);
    }

    public CompletableFuture<String> name() {
        return this.initializationFuture.thenApply(v -> this.pagedItem.fieldName());
    }

    public CompletableFuture<Integer> pageSize() {
        return this.initializationFuture.thenApply(v -> this.pageSize);
    }

    public CompletableFuture<Integer> size() {
        return this.initializationFuture.thenApply(v -> this.page.size());
    }
}

