/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.api.core.InternalApi;
import com.google.genai.errors.GenAiIOException;
import java.io.IOException;
import java.time.Duration;

public abstract class JsonSerializable {
    static final ObjectMapper objectMapper = new ObjectMapper();

    public String toJson() {
        return JsonSerializable.toJsonString(this);
    }

    static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to serialize the object to JSON.", e);
        }
    }

    static JsonNode toJsonNode(Object object) {
        return objectMapper.valueToTree(object);
    }

    @InternalApi
    protected static <T extends JsonSerializable> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.readValue(jsonString, clazz));
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to deserialize the JSON string.", e);
        }
    }

    static <T extends JsonSerializable> T fromJsonNode(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.treeToValue((TreeNode)jsonNode, clazz));
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to deserialize the JSON node.", e);
        }
    }

    static JsonNode stringToJsonNode(String string) {
        try {
            return objectMapper.readTree(string);
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to parse the JSON string.", e);
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.registerModule(new Jdk8Module());
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule customModule = new SimpleModule();
        customModule.addSerializer(Duration.class, new CustomDurationSerializer());
        customModule.addDeserializer(Duration.class, new CustomDurationDeserializer());
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(customModule);
    }

    static class CustomDurationSerializer
    extends JsonSerializer<Duration> {
        CustomDurationSerializer() {
        }

        @Override
        public void serialize(Duration duration, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (duration == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(duration.getSeconds() + "s");
            }
        }
    }

    static class CustomDurationDeserializer
    extends JsonDeserializer<Duration> {
        CustomDurationDeserializer() {
        }

        @Override
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String value = p.getValueAsString();
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (value.endsWith("s")) {
                String secondsPart = value.substring(0, value.length() - 1);
                try {
                    long seconds = Long.parseLong(secondsPart);
                    return Duration.ofSeconds(seconds);
                }
                catch (NumberFormatException e) {
                    throw ctxt.weirdStringException(value, Duration.class, "Cannot parse duration from string: " + value + ". Expected format 'Xs'.");
                }
            }
            throw ctxt.weirdStringException(value, Duration.class, "Expected duration in format 'Xs', but got: " + value);
        }
    }
}

