/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.FetchPredictOperationConfig;
import com.google.genai.types.FetchPredictOperationParameters;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GetOperationConfig;
import com.google.genai.types.GetOperationParameters;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public final class Operations {
    final ApiClient apiClient;

    public Operations(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getOperationParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getOperationParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fetchPredictOperationParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"resourceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "resourceName"}, Common.getValueByPath(fromObject, new String[]{"resourceName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"video", "uri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"video", "uri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"video", "encodedVideo"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(this.apiClient, Common.getValueByPath(fromObject, new String[]{"video", "encodedVideo"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"encoding"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"encoding"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generatedVideoFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"_self"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"_self"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosResponseFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"generatedSamples"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"generatedSamples"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add(this.generatedVideoFromMldev(apiClient, JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosOperationFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoFromVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(this.apiClient, Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generatedVideoFromVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"_self"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromVertex(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"_self"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosResponseFromVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videos"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"videos"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add(this.generatedVideoFromVertex(apiClient, JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosOperationFromVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromVertex(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    GenerateVideosOperation privateGetVideosOperation(String operationName, GetOperationConfig config) {
        String path;
        ObjectNode body;
        GetOperationParameters.Builder parameterBuilder = GetOperationParameters.builder();
        if (!Common.isZero(operationName)) {
            parameterBuilder.operationName(operationName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getOperationParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{operationName}", body.get("_url"));
        } else {
            body = this.getOperationParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{operationName}", body.get("_url")) : "{operationName}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("get", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString(entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.generateVideosOperationFromVertex(this.apiClient, responseNode, null) : this.generateVideosOperationFromMldev(this.apiClient, responseNode, null);
            GenerateVideosOperation generateVideosOperation = JsonSerializable.fromJsonNode(responseNode, GenerateVideosOperation.class);
            return generateVideosOperation;
        }
    }

    GenerateVideosOperation privateFetchPredictVideosOperation(String operationName, String resourceName, FetchPredictOperationConfig config) {
        FetchPredictOperationParameters.Builder parameterBuilder = FetchPredictOperationParameters.builder();
        if (!Common.isZero(operationName)) {
            parameterBuilder.operationName(operationName);
        }
        if (!Common.isZero(resourceName)) {
            parameterBuilder.resourceName(resourceName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (!this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is not supported by the Gemini Developer API.");
        }
        ObjectNode body = this.fetchPredictOperationParametersToVertex(this.apiClient, parameterNode, null);
        String path = Common.formatMap("{resourceName}:fetchPredictOperation", body.get("_url"));
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("post", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString(entity);
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            if (!this.apiClient.vertexAI()) {
                throw new UnsupportedOperationException("This method is not supported by the Gemini Developer API.");
            }
            responseNode = this.generateVideosOperationFromVertex(this.apiClient, responseNode, null);
            GenerateVideosOperation generateVideosOperation = JsonSerializable.fromJsonNode(responseNode, GenerateVideosOperation.class);
            return generateVideosOperation;
        }
    }

    public GenerateVideosOperation getVideosOperation(GenerateVideosOperation operation, GetOperationConfig config) {
        if (!operation.name().isPresent()) {
            throw new Error("Operation name is required.");
        }
        if (this.apiClient.vertexAI()) {
            String resourceName = operation.name().get().split("/operations/")[0];
            FetchPredictOperationConfig fetchConfig = FetchPredictOperationConfig.builder().build();
            return this.privateFetchPredictVideosOperation(operation.name().get(), resourceName, fetchConfig);
        }
        return this.privateGetVideosOperation(operation.name().get(), config);
    }
}

