/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.genai.BasePager;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import java.util.Iterator;
import java.util.function.Function;

public class Pager<T extends JsonSerializable>
extends BasePager<T>
implements Iterable<T> {
    private final PagerIterator iterator;

    Pager(BasePager.PagedItem pagedItem, Function<JsonSerializable, Object> request, ObjectNode requestConfig, JsonNode response) {
        super(pagedItem, requestConfig);
        this.initNewPage(response);
        this.iterator = new PagerIterator(request);
    }

    public ImmutableList<T> nextPage() {
        this.iterator.fetchNextPage();
        return this.page();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    public String name() {
        return this.pagedItem.fieldName();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int size() {
        return this.page.size();
    }

    public ImmutableList<T> page() {
        return this.page;
    }

    private class PagerIterator
    implements Iterator<T> {
        private final Function<JsonSerializable, Object> request;
        private int currentIndex;

        PagerIterator(Function<JsonSerializable, Object> request) {
            this.request = request;
            this.currentIndex = 0;
        }

        private void fetchNextPage() {
            if (Pager.this.requestConfig.get("pageToken") == null) {
                throw new IndexOutOfBoundsException("No more page in the pager.");
            }
            try {
                Pager.this.initNewPage(JsonSerializable.toJsonNode(this.request.apply(JsonSerializable.fromJsonNode(Pager.this.requestConfig, Pager.this.pagedItem.requestConfigClass()))));
                this.currentIndex = 0;
            }
            catch (Exception e) {
                throw new GenAiIOException("Failed to fetch the next page. " + e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < Pager.this.page.size() || Pager.this.requestConfig.get("pageToken") != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more items in the pager.");
            }
            if (this.currentIndex < Pager.this.page.size()) {
                JsonSerializable current = (JsonSerializable)Pager.this.page.get(this.currentIndex);
                ++this.currentIndex;
                return current;
            }
            this.fetchNextPage();
            return this.next();
        }
    }
}

