/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.errors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.genai.errors.BaseException;
import com.google.genai.errors.ClientException;
import com.google.genai.errors.ServerException;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class ApiException
extends BaseException {
    private final int code;
    private final String status;
    private final String message;

    public ApiException(int code, String status, String message) {
        super(String.format("%d %s. %s", code, status, message));
        this.code = code;
        this.status = status;
        this.message = message;
    }

    public static void throwFromResponse(CloseableHttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        int code = statusLine.getStatusCode();
        if (code == 200) {
            return;
        }
        String status = statusLine.getReasonPhrase();
        String message = ApiException.getErrorMessageFromResponse(response);
        if (code >= 400 && code < 500) {
            throw new ClientException(code, status, message);
        }
        if (code >= 500 && code < 600) {
            throw new ServerException(code, status, message);
        }
        throw new ApiException(code, status, message);
    }

    static String getErrorMessageFromResponse(CloseableHttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            JsonNode messageNode;
            String responseBody = EntityUtils.toString(entity);
            if (responseBody == null || responseBody.isEmpty()) {
                return "";
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode errorNode = mapper.readTree(responseBody).get("error");
            if (errorNode != null && errorNode.isObject() && (messageNode = errorNode.get("message")) != null && messageNode.isTextual()) {
                return messageNode.asText();
            }
            return "";
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public int code() {
        return this.code;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }
}

