/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.FunctionCallingConfig;
import com.google.genai.types.FunctionCallingConfigMode;
import java.util.List;
import java.util.Optional;

final class AutoValue_FunctionCallingConfig
extends FunctionCallingConfig {
    private final Optional<FunctionCallingConfigMode> mode;
    private final Optional<List<String>> allowedFunctionNames;

    private AutoValue_FunctionCallingConfig(Optional<FunctionCallingConfigMode> mode, Optional<List<String>> allowedFunctionNames) {
        this.mode = mode;
        this.allowedFunctionNames = allowedFunctionNames;
    }

    @Override
    @JsonProperty(value="mode")
    public Optional<FunctionCallingConfigMode> mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="allowedFunctionNames")
    public Optional<List<String>> allowedFunctionNames() {
        return this.allowedFunctionNames;
    }

    public String toString() {
        return "FunctionCallingConfig{mode=" + this.mode + ", allowedFunctionNames=" + this.allowedFunctionNames + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FunctionCallingConfig) {
            FunctionCallingConfig that = (FunctionCallingConfig)o;
            return this.mode.equals(that.mode()) && this.allowedFunctionNames.equals(that.allowedFunctionNames());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.allowedFunctionNames.hashCode();
    }

    @Override
    public FunctionCallingConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FunctionCallingConfig.Builder {
        private Optional<FunctionCallingConfigMode> mode = Optional.empty();
        private Optional<List<String>> allowedFunctionNames = Optional.empty();

        Builder() {
        }

        Builder(FunctionCallingConfig source2) {
            this.mode = source2.mode();
            this.allowedFunctionNames = source2.allowedFunctionNames();
        }

        @Override
        public FunctionCallingConfig.Builder mode(FunctionCallingConfigMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        @Override
        public FunctionCallingConfig.Builder allowedFunctionNames(List<String> allowedFunctionNames) {
            this.allowedFunctionNames = Optional.of(allowedFunctionNames);
            return this;
        }

        @Override
        public FunctionCallingConfig build() {
            return new AutoValue_FunctionCallingConfig(this.mode, this.allowedFunctionNames);
        }
    }
}

