/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Interval;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_Interval
extends Interval {
    private final Optional<Instant> startTime;
    private final Optional<Instant> endTime;

    private AutoValue_Interval(Optional<Instant> startTime, Optional<Instant> endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    @JsonProperty(value="startTime")
    public Optional<Instant> startTime() {
        return this.startTime;
    }

    @Override
    @JsonProperty(value="endTime")
    public Optional<Instant> endTime() {
        return this.endTime;
    }

    public String toString() {
        return "Interval{startTime=" + this.startTime + ", endTime=" + this.endTime + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Interval) {
            Interval that = (Interval)o;
            return this.startTime.equals(that.startTime()) && this.endTime.equals(that.endTime());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.startTime.hashCode();
        h$ *= 1000003;
        return h$ ^= this.endTime.hashCode();
    }

    @Override
    public Interval.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Interval.Builder {
        private Optional<Instant> startTime = Optional.empty();
        private Optional<Instant> endTime = Optional.empty();

        Builder() {
        }

        Builder(Interval source2) {
            this.startTime = source2.startTime();
            this.endTime = source2.endTime();
        }

        @Override
        public Interval.Builder startTime(Instant startTime) {
            this.startTime = Optional.of(startTime);
            return this;
        }

        @Override
        public Interval.Builder endTime(Instant endTime) {
            this.endTime = Optional.of(endTime);
            return this;
        }

        @Override
        public Interval build() {
            return new AutoValue_Interval(this.startTime, this.endTime);
        }
    }
}

