/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.verticalslabs.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<? extends VerticalSlabBlock> CODEC = VerticalSlabBlock.simpleCodec(VerticalSlabBlock::new);
    public static final BooleanProperty SINGLE = BooleanProperty.create((String)"single_slab");

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SINGLE});
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public VerticalSlabBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).trySetValue((Property)SINGLE, (Comparable)Boolean.valueOf(true)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).trySetValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter view, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        if (!((Boolean)state.getValue((Property)SINGLE)).booleanValue()) {
            return Shapes.block();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
            case Direction.EAST -> Shapes.create((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.SOUTH -> Shapes.create((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            case Direction.WEST -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
            default -> Shapes.block();
        };
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (!((Boolean)state.getValue((Property)SINGLE)).booleanValue() || !itemStack.is(this.asItem())) {
            return false;
        }
        if (!context.replacingClickedOnBlock()) {
            return true;
        }
        double hitposX = context.getClickLocation().x - (double)context.getClickedPos().getX();
        double hitposZ = context.getClickLocation().z - (double)context.getClickedPos().getZ();
        Direction facingDirection = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (facingDirection) {
            case NORTH: {
                return hitposZ >= 0.5;
            }
            case EAST: {
                return hitposX <= 0.5;
            }
            case SOUTH: {
                return hitposZ <= 0.5;
            }
            case WEST: {
                return hitposX >= 0.5;
            }
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState replacingBlockState = ctx.getLevel().getBlockState(blockPos);
        FluidState replacingFluidState = ctx.getLevel().getFluidState(blockPos);
        if (replacingBlockState.is((Block)this)) {
            return (BlockState)((BlockState)replacingBlockState.setValue((Property)SINGLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(replacingFluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return state.getFluidState();
    }

    public boolean placeLiquid(@NotNull LevelAccessor world, @NotNull BlockPos pos, BlockState state, @NotNull FluidState fluidState) {
        if (((Boolean)state.getValue((Property)SINGLE)).booleanValue()) {
            return super.placeLiquid(world, pos, state, fluidState);
        }
        return false;
    }

    public boolean canPlaceLiquid(@Nullable LivingEntity p_393688_, BlockGetter p_56301_, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        if (((Boolean)blockState.getValue((Property)SINGLE)).booleanValue()) {
            return super.canPlaceLiquid(p_393688_, p_56301_, blockPos, blockState, fluid);
        }
        return false;
    }

    @NotNull
    protected BlockState updateShape(BlockState blockState, @NotNull LevelReader levelReader, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos pos2, @NotNull BlockState blockState2, @NotNull RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(blockState, levelReader, scheduledTickAccess, pos, direction, pos2, blockState2, randomSource);
    }

    protected boolean isPathfindable(BlockState state, @NotNull PathComputationType type) {
        return (Boolean)state.getValue((Property)SINGLE) == false;
    }

    @NotNull
    protected MapCodec<? extends VerticalSlabBlock> codec() {
        return CODEC;
    }
}

