/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.verticalslabs.mixin;

import games.enchanted.verticalslabs.block.SpecialBlockMaps;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WeatheringCopper.class})
public interface WeatheringCopperMixin {
    @Inject(at={@At(value="HEAD")}, method={"getPrevious(Lnet/minecraft/world/level/block/Block;)Ljava/util/Optional;"}, cancellable=true)
    private static void getPrevious(Block block, CallbackInfoReturnable<Optional<Block>> ci) {
        Block previous;
        if (SpecialBlockMaps.WEATHERING_COPPER_MAP != null && (previous = (Block)SpecialBlockMaps.WEATHERING_COPPER_MAP.inverse().get((Object)block)) != null) {
            ci.setReturnValue(Optional.of(previous));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getFirst(Lnet/minecraft/world/level/block/Block;)Lnet/minecraft/world/level/block/Block;"}, cancellable=true)
    private static void getFirst(Block block, CallbackInfoReturnable<Block> ci) {
        if (SpecialBlockMaps.WEATHERING_COPPER_MAP != null) {
            Block previous;
            Block first = block;
            while ((previous = (Block)SpecialBlockMaps.WEATHERING_COPPER_MAP.inverse().get((Object)first)) != null) {
                first = previous;
            }
            if (first != block) {
                ci.setReturnValue((Object)first);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getNext(Lnet/minecraft/world/level/block/Block;)Ljava/util/Optional;"}, cancellable=true)
    private static void getNext(Block block, CallbackInfoReturnable<Optional<Block>> ci) {
        Block next;
        if (SpecialBlockMaps.WEATHERING_COPPER_MAP != null && (next = (Block)SpecialBlockMaps.WEATHERING_COPPER_MAP.get((Object)block)) != null) {
            ci.setReturnValue(Optional.of(next));
        }
    }
}

