/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.verticalslabs.platform;

import games.enchanted.verticalslabs.EnchantedVerticalSlabsConstants;
import games.enchanted.verticalslabs.EnchantedVerticalSlabsMod;
import games.enchanted.verticalslabs.item.ModCreativeTab;
import games.enchanted.verticalslabs.item.ModCreativeTabs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class NeoForgeCreativeTabRegistration {
    public static void addItemsInExistingTabs(BuildCreativeModeTabContentsEvent event) {
        for (int i = 0; i < ModCreativeTabs.modCreativeTabs.length; ++i) {
            for (int j = 0; j < ModCreativeTabs.modCreativeTabs[i].groupEntries.length; ++j) {
                ModCreativeTab.ModCreativeTabEntry entry = ModCreativeTabs.modCreativeTabs[i].groupEntries[j];
                if (!entry.canBeAddedToOtherGroups() || event.getTabKey() != entry.additionalTab) continue;
                try {
                    switch (entry.insertionPosition) {
                        case 0: {
                            event.accept(entry.item.getDefaultInstance());
                            break;
                        }
                        case 2: {
                            event.insertAfter(entry.relatedItem.getDefaultInstance(), entry.item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                            break;
                        }
                        case 3: {
                            event.insertBefore(entry.relatedItem.getDefaultInstance(), entry.item.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: '" + entry.insertionPosition + "' for creative mode tab insertionPosition");
                        }
                    }
                    continue;
                }
                catch (IllegalStateException e) {
                    EnchantedVerticalSlabsConstants.LOG.warn("An exception occured running BuildCreativeModeTabContentsEvent:\n", (Throwable)e);
                }
            }
        }
    }

    public static void registerTabs() {
        int i = 0;
        while (i < ModCreativeTabs.modCreativeTabs.length) {
            int finalI = i++;
            CreativeModeTab TAB = CreativeModeTab.builder().title(ModCreativeTabs.modCreativeTabs[finalI].groupTitle).icon(() -> new ItemStack((ItemLike)ModCreativeTabs.modCreativeTabs[finalI].groupIcon)).displayItems((params, output) -> {
                for (int i2 = 0; i2 < ModCreativeTabs.modCreativeTabs[finalI].groupEntries.length; ++i2) {
                    output.accept((ItemLike)ModCreativeTabs.modCreativeTabs[finalI].groupEntries[i2].item);
                }
            }).build();
            EnchantedVerticalSlabsMod.register(BuiltInRegistries.CREATIVE_MODE_TAB.key(), () -> TAB, ResourceLocation.fromNamespaceAndPath((String)"enchanted-vertical-slabs", (String)ModCreativeTabs.modCreativeTabs[finalI].registryName));
        }
    }
}

