/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.verticalslabs.registry;

import games.enchanted.verticalslabs.EnchantedVerticalSlabsMod;
import games.enchanted.verticalslabs.block.BlockAndItemContainer;
import games.enchanted.verticalslabs.block.VerticalSlabBlock;
import games.enchanted.verticalslabs.block.WeatheringCopperVerticalSlabBlock;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class RegistryHelpers {
    private static BlockItem registerBlockItem(ResourceLocation location, Block block) {
        Item.Properties settings = new Item.Properties();
        ResourceKey itemResourceKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
        settings.useBlockDescriptionPrefix().setId(itemResourceKey);
        return EnchantedVerticalSlabsMod.register(BuiltInRegistries.ITEM.key(), () -> new BlockItem(block, settings), location);
    }

    private static Block registerVerticalSlabBlock(ResourceLocation location, BlockBehaviour.Properties blockSettings) {
        return (Block)EnchantedVerticalSlabsMod.register(BuiltInRegistries.BLOCK.key(), () -> new VerticalSlabBlock(blockSettings), location);
    }

    private static Block registerVerticalSlabBlock(ResourceLocation location, BlockBehaviour.Properties blockSettings, WeatheringCopper.WeatherState oxidationLevel) {
        return (Block)EnchantedVerticalSlabsMod.register(BuiltInRegistries.BLOCK.key(), () -> new WeatheringCopperVerticalSlabBlock(oxidationLevel, blockSettings), location);
    }

    public static BlockAndItemContainer registerVerticalSlab(String id, BlockBehaviour.Properties blockProperties) {
        return RegistryHelpers.registerVerticalSlab(id, blockProperties, null);
    }

    public static BlockAndItemContainer registerVerticalSlab(String id, BlockBehaviour.Properties blockProperties, WeatheringCopper.WeatherState oxidationLevel) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"enchanted-vertical-slabs", (String)id);
        ResourceKey blockResourceKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location);
        blockProperties.setId(blockResourceKey);
        Block registeredBlock = oxidationLevel == null ? RegistryHelpers.registerVerticalSlabBlock(location, blockProperties) : RegistryHelpers.registerVerticalSlabBlock(location, blockProperties, oxidationLevel);
        BlockItem registeredBlockItem = RegistryHelpers.registerBlockItem(location, registeredBlock);
        return new BlockAndItemContainer(registeredBlock, registeredBlockItem);
    }
}

