/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardinigcalculator;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CalculatorCommand {
    private static final Pattern MATH_PATTERN = Pattern.compile("^(-?\\d+(?:\\.\\d+)?)\\s*([+\\-*/])\\s*(-?\\d+(?:\\.\\d+)?)$");
    private static final Pattern PARENTHESES_PATTERN = Pattern.compile("\\(([^()]+)\\)");
    private static final Random RANDOM = new Random();
    private static final Map<String, Map<String, Integer>> CRAFTING_RECIPES = new HashMap<String, Map<String, Integer>>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder calculator = class_2170.method_9247((String)"calculator");
        LiteralArgumentBuilder help = (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(CalculatorCommand::executeHelp);
        calculator.then((ArgumentBuilder)help);
        calculator.then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(CalculatorCommand::execute));
        LiteralArgumentBuilder craft = class_2170.method_9247((String)"craft");
        craft.then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"quantity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeCraftRecipe)));
        calculator.then((ArgumentBuilder)craft);
        LiteralArgumentBuilder stack = class_2170.method_9247((String)"stack");
        stack.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9247((String)"sb").executes(CalculatorCommand::executeStackShulker))).executes(CalculatorCommand::executeStack));
        calculator.then((ArgumentBuilder)stack);
        LiteralArgumentBuilder nether = class_2170.method_9247((String)"nether");
        nether.then(class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"y", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word()).executes(context -> {
            double z;
            double y;
            double x;
            String xStr = StringArgumentType.getString((CommandContext)context, (String)"x");
            String yStr = StringArgumentType.getString((CommandContext)context, (String)"y");
            String zStr = StringArgumentType.getString((CommandContext)context, (String)"z");
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
                return 0;
            }
            class_3222 player = source.method_9207();
            class_2338 playerPos = player.method_24515();
            try {
                x = xStr.equals("~") ? (double)playerPos.method_10263() : Double.parseDouble(xStr);
                y = yStr.equals("~") ? (double)playerPos.method_10264() : Double.parseDouble(yStr);
                z = zStr.equals("~") ? (double)playerPos.method_10260() : Double.parseDouble(zStr);
            }
            catch (NumberFormatException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid coordinates! Use numbers or ~ for current position.").method_27692(class_124.field_1061));
                return 0;
            }
            double netherX = x / 8.0;
            double netherZ = z / 8.0;
            source.method_9226(() -> class_2561.method_43470((String)"Nether Coordinates:").method_27692(class_124.field_1065), false);
            source.method_9226(() -> class_2561.method_43470((String)("X: " + CalculatorCommand.formatCoord(netherX) + ", Y: " + CalculatorCommand.formatCoord(y) + ", Z: " + CalculatorCommand.formatCoord(netherZ))).method_27692(class_124.field_1054), false);
            return 1;
        }))));
        nether.executes(CalculatorCommand::executeNetherCurrent);
        calculator.then((ArgumentBuilder)nether);
        LiteralArgumentBuilder overworld = class_2170.method_9247((String)"overworld");
        overworld.then(class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"y", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word()).executes(CalculatorCommand::executeOverworldCoords))));
        overworld.executes(CalculatorCommand::executeOverworld);
        calculator.then((ArgumentBuilder)overworld);
        LiteralArgumentBuilder hoppertimer = class_2170.method_9247((String)"hoppertimer");
        hoppertimer.then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeHopperTimer));
        calculator.then((ArgumentBuilder)hoppertimer);
        LiteralArgumentBuilder hoppertimerticks = class_2170.method_9247((String)"hoppertimerticks");
        hoppertimerticks.then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeHopperTimerTicks));
        calculator.then((ArgumentBuilder)hoppertimerticks);
        LiteralArgumentBuilder distance = class_2170.method_9247((String)"distance");
        distance.then(class_2170.method_9244((String)"x1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"x2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeDistance)))))));
        distance.executes(CalculatorCommand::executeDistanceFromCurrent);
        calculator.then((ArgumentBuilder)distance);
        LiteralArgumentBuilder area = class_2170.method_9247((String)"area");
        area.then(class_2170.method_9244((String)"length", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeArea)));
        calculator.then((ArgumentBuilder)area);
        LiteralArgumentBuilder volume = class_2170.method_9247((String)"volume");
        volume.then(class_2170.method_9244((String)"length", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeVolume))));
        calculator.then((ArgumentBuilder)volume);
        LiteralArgumentBuilder square = (LiteralArgumentBuilder)class_2170.method_9247((String)"sq").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSquare));
        calculator.then((ArgumentBuilder)square);
        LiteralArgumentBuilder cube = (LiteralArgumentBuilder)class_2170.method_9247((String)"cube").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeCube));
        calculator.then((ArgumentBuilder)cube);
        LiteralArgumentBuilder power = class_2170.method_9247((String)"power");
        power.then(class_2170.method_9244((String)"base", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"exponent", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executePower)));
        calculator.then((ArgumentBuilder)power);
        LiteralArgumentBuilder sqrt = (LiteralArgumentBuilder)class_2170.method_9247((String)"sqrt").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSqrt));
        calculator.then((ArgumentBuilder)sqrt);
        LiteralArgumentBuilder secToTicks = class_2170.method_9247((String)"secToTicks");
        secToTicks.then(class_2170.method_9244((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSecToTicks));
        calculator.then((ArgumentBuilder)secToTicks);
        LiteralArgumentBuilder tickToSec = class_2170.method_9247((String)"tickToSec");
        tickToSec.then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).executes(CalculatorCommand::executeTickToSec));
        calculator.then((ArgumentBuilder)tickToSec);
        LiteralArgumentBuilder random = class_2170.method_9247((String)"random");
        random.then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeRandom));
        random.executes(CalculatorCommand::executeRandomDefault);
        calculator.then((ArgumentBuilder)random);
        dispatcher.register((LiteralArgumentBuilder)calculator.executes(CalculatorCommand::executeHelp));
    }

    private static int executeHelp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== IG Calculator Help ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"This mod allows you to perform calculations and conversions in-game!").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Basic Math:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator <number> <operator> <number>").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Operators: + - * / (supports parentheses)").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Example: /calculator (2+3) * 4").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Advanced Math:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator sq <number> - Square").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator cube <number> - Cube").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator power <base> <exponent> - Power").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator sqrt <number> - Square root").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator random [max] - Random number (default 0-1000)").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Stack Calculator:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator stack <amount> - Convert to stacks").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator stack <amount> sb - Include shulker boxes").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Geometry:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator area <length> <width> - Rectangle area").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator volume <length> <width> <height> - Box volume").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator distance <x1> <y1> <z1> <x2> <y2> <z2> - 3D distance").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Minecraft Tools:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator nether [~ ~ ~] or [x y z] - Nether coordinates").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator overworld [~ ~ ~] or [x y z] - Overworld coordinates").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator hoppertimer <seconds> - Items needed for timer").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator hoppertimerticks <ticks> - Items needed for tick timer").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator secToTicks <seconds> - Convert seconds to ticks").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator tickToSec <ticks> - Convert ticks to seconds").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator craft <item> amount <quantity> - Crafting calculator").method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        String expression = StringArgumentType.getString(context, (String)"expression");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        try {
            double result = CalculatorCommand.calculateExpression(expression);
            String formattedResult = CalculatorCommand.formatResult(result);
            source.method_9226(() -> class_2561.method_43470((String)"Calculator Result: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(expression + " = " + formattedResult)).method_27692(class_124.field_1054)), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid expression! " + e.getMessage())).method_27692(class_124.field_1061));
            source.method_9226(() -> class_2561.method_43470((String)"Use ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"/calculator help").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" for detailed help.").method_27692(class_124.field_1080)), false);
            return 0;
        }
    }

    private static int executeCraftRecipe(CommandContext<class_2168> context) throws CommandSyntaxException {
        String itemName = StringArgumentType.getString(context, (String)"item");
        int quantity = IntegerArgumentType.getInteger(context, (String)"quantity");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        String cleanItemName = itemName.startsWith("minecraft:") ? itemName.substring(10) : itemName;
        Map<String, Integer> recipe = CRAFTING_RECIPES.get(cleanItemName);
        if (recipe == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No crafting recipe found for: " + cleanItemName)).method_27692(class_124.field_1061));
            source.method_9226(() -> class_2561.method_43470((String)("Available recipes: " + String.join((CharSequence)", ", CRAFTING_RECIPES.keySet()))).method_27692(class_124.field_1080), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Crafting Calculator ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Item: " + cleanItemName + " x" + quantity)).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        int totalItemsNeeded = 0;
        for (Map.Entry<String, Integer> ingredient : recipe.entrySet()) {
            String ingredientName = ingredient.getKey();
            int baseAmount = ingredient.getValue();
            int totalAmount = baseAmount * quantity;
            totalItemsNeeded += totalAmount;
            int stackSize = CalculatorCommand.getItemStackSize(ingredientName);
            if (stackSize == -1) {
                stackSize = 64;
            }
            int stacks = totalAmount / stackSize;
            int remainder = totalAmount % stackSize;
            String finalIngredientName = ingredientName;
            int finalBaseAmount = baseAmount;
            int finalTotalAmount = totalAmount;
            int finalStacks = stacks;
            int finalRemainder = remainder;
            source.method_9226(() -> class_2561.method_43470((String)(finalIngredientName + ": " + finalBaseAmount + " x " + quantity + " = " + finalTotalAmount + " \u2192 " + finalStacks + " stacks and " + finalRemainder + " items")).method_27692(class_124.field_1068), false);
        }
        int totalStacks = totalItemsNeeded / 64;
        int totalRemainder = totalItemsNeeded % 64;
        int finalTotalItemsNeeded = totalItemsNeeded;
        int finalTotalStacks = totalStacks;
        int finalTotalRemainder = totalRemainder;
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total items needed: " + finalTotalItemsNeeded + " \u2192 " + finalTotalStacks + " stacks and " + finalTotalRemainder + " items")).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeStack(CommandContext<class_2168> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int stacks = amount / 64;
        int remainder = amount % 64;
        source.method_9226(() -> class_2561.method_43470((String)"Stack Calculator:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Amount: " + amount + " items")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + stacks + " stacks and " + remainder + " items")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeStackShulker(CommandContext<class_2168> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int stacks = amount / 64;
        int remainder = amount % 64;
        int shulkerBoxes = (int)Math.ceil((double)stacks / 27.0);
        int remainingStacks = stacks % 27;
        source.method_9226(() -> class_2561.method_43470((String)"Shulker Box Calculator:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Amount: " + amount + " items")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + stacks + " stacks and " + remainder + " items")).method_27692(class_124.field_1054), false);
        if (shulkerBoxes > 0) {
            String shulkerText = shulkerBoxes == 1 ? "shulker box" : "shulker boxes";
            String stackText = remainingStacks == 1 ? "stack" : "stacks";
            source.method_9226(() -> class_2561.method_43470((String)("Shulker storage: " + shulkerBoxes + " " + shulkerText + " and " + remainingStacks + " " + stackText)).method_27692(class_124.field_1075), false);
        }
        return 1;
    }

    private static int executeOverworldCoords(CommandContext<class_2168> context) throws CommandSyntaxException {
        double z;
        double y;
        double x;
        String xStr = StringArgumentType.getString(context, (String)"x");
        String yStr = StringArgumentType.getString(context, (String)"y");
        String zStr = StringArgumentType.getString(context, (String)"z");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 playerPos = player.method_24515();
        try {
            x = xStr.equals("~") ? (double)playerPos.method_10263() : Double.parseDouble(xStr);
            y = yStr.equals("~") ? (double)playerPos.method_10264() : Double.parseDouble(yStr);
            z = zStr.equals("~") ? (double)playerPos.method_10260() : Double.parseDouble(zStr);
        }
        catch (NumberFormatException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid coordinates! Use numbers or ~ for current position.").method_27692(class_124.field_1061));
            return 0;
        }
        double overworldX = x * 8.0;
        double overworldZ = z * 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Overworld Coordinates:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Nether: " + CalculatorCommand.formatCoord(x) + ", " + CalculatorCommand.formatCoord(y) + ", " + CalculatorCommand.formatCoord(z))).method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Overworld: " + CalculatorCommand.formatCoord(overworldX) + ", " + CalculatorCommand.formatCoord(y) + ", " + CalculatorCommand.formatCoord(overworldZ))).method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int executeNetherCurrent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 pos = player.method_24515();
        double netherX = (double)pos.method_10263() / 8.0;
        double netherZ = (double)pos.method_10260() / 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Nether Coordinates:").method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Current Overworld: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Nether: " + CalculatorCommand.formatCoord(netherX) + ", " + pos.method_10264() + ", " + CalculatorCommand.formatCoord(netherZ))).method_27692(class_124.field_1065), false);
        return 1;
    }

    private static int executeOverworld(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 pos = player.method_24515();
        double overworldX = (double)pos.method_10263() * 8.0;
        double overworldZ = (double)pos.method_10260() * 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Overworld Coordinates:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Current Nether: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Overworld: " + CalculatorCommand.formatCoord(overworldX) + ", " + pos.method_10264() + ", " + CalculatorCommand.formatCoord(overworldZ))).method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int executeHopperTimer(CommandContext<class_2168> context) throws CommandSyntaxException {
        int seconds = IntegerArgumentType.getInteger(context, (String)"seconds");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int ticks = seconds * 20;
        int items = (int)Math.ceil((double)ticks / 8.0);
        source.method_9226(() -> class_2561.method_43470((String)"Hopper Timer:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Time: " + seconds + " seconds (" + ticks + " ticks)")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Items needed in hopper: " + items)).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeHopperTimerTicks(CommandContext<class_2168> context) throws CommandSyntaxException {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double seconds = (double)ticks / 20.0;
        int items = (int)Math.ceil((double)ticks / 8.0);
        source.method_9226(() -> class_2561.method_43470((String)"Hopper Timer:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Time: " + ticks + " ticks (" + CalculatorCommand.formatResult(seconds) + " seconds)")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Items needed in hopper: " + items)).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeDistance(CommandContext<class_2168> context) throws CommandSyntaxException {
        double x1 = DoubleArgumentType.getDouble(context, (String)"x1");
        double y1 = DoubleArgumentType.getDouble(context, (String)"y1");
        double z1 = DoubleArgumentType.getDouble(context, (String)"z1");
        double x2 = DoubleArgumentType.getDouble(context, (String)"x2");
        double y2 = DoubleArgumentType.getDouble(context, (String)"y2");
        double z2 = DoubleArgumentType.getDouble(context, (String)"z2");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double distance = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        source.method_9226(() -> class_2561.method_43470((String)"Distance Calculation:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("From: (" + CalculatorCommand.formatCoord(x1) + ", " + CalculatorCommand.formatCoord(y1) + ", " + CalculatorCommand.formatCoord(z1) + ")")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("To: (" + CalculatorCommand.formatCoord(x2) + ", " + CalculatorCommand.formatCoord(y2) + ", " + CalculatorCommand.formatCoord(z2) + ")")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Distance: " + CalculatorCommand.formatResult(distance) + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeDistanceFromCurrent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Please specify target coordinates: /calculator distance <x1> <y1> <z1> <x2> <y2> <z2>").method_27692(class_124.field_1061));
        return 0;
    }

    private static int executeArea(CommandContext<class_2168> context) throws CommandSyntaxException {
        double length = DoubleArgumentType.getDouble(context, (String)"length");
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double area = length * width;
        source.method_9226(() -> class_2561.method_43470((String)"Area Calculation:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Length: " + CalculatorCommand.formatResult(length) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + CalculatorCommand.formatResult(width) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Area: " + CalculatorCommand.formatResult(area) + " blocks\u00b2")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeVolume(CommandContext<class_2168> context) throws CommandSyntaxException {
        double length = DoubleArgumentType.getDouble(context, (String)"length");
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double volume = length * width * height;
        source.method_9226(() -> class_2561.method_43470((String)"Volume Calculation:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Length: " + CalculatorCommand.formatResult(length) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + CalculatorCommand.formatResult(width) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Height: " + CalculatorCommand.formatResult(height) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Volume: " + CalculatorCommand.formatResult(volume) + " blocks\u00b3")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSquare(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = number * number;
        source.method_9226(() -> class_2561.method_43470((String)"Square Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(number) + "\u00b2 = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeCube(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = number * number * number;
        source.method_9226(() -> class_2561.method_43470((String)"Cube Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(number) + "\u00b3 = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executePower(CommandContext<class_2168> context) throws CommandSyntaxException {
        double base = DoubleArgumentType.getDouble(context, (String)"base");
        double exponent = DoubleArgumentType.getDouble(context, (String)"exponent");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = Math.pow(base, exponent);
        source.method_9226(() -> class_2561.method_43470((String)"Power Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(base) + "^" + CalculatorCommand.formatResult(exponent) + " = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSqrt(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        if (number < 0.0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot calculate square root of negative number!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = Math.sqrt(number);
        source.method_9226(() -> class_2561.method_43470((String)"Square Root Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u221a" + CalculatorCommand.formatResult(number) + " = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSecToTicks(CommandContext<class_2168> context) throws CommandSyntaxException {
        double seconds = DoubleArgumentType.getDouble(context, (String)"seconds");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double ticks = seconds * 20.0;
        source.method_9226(() -> class_2561.method_43470((String)"Time Conversion:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(seconds) + " seconds = " + CalculatorCommand.formatResult(ticks) + " ticks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeTickToSec(CommandContext<class_2168> context) throws CommandSyntaxException {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double seconds = (double)ticks / 20.0;
        source.method_9226(() -> class_2561.method_43470((String)"Time Conversion:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)(ticks + " ticks = " + CalculatorCommand.formatResult(seconds) + " seconds")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeRandom(CommandContext<class_2168> context) throws CommandSyntaxException {
        int max = IntegerArgumentType.getInteger(context, (String)"max");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int randomNumber = RANDOM.nextInt(max + 1);
        source.method_9226(() -> class_2561.method_43470((String)"Random Number:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)("Range: 0 to " + max)).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + randomNumber)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeRandomDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int randomNumber = RANDOM.nextInt(1001);
        source.method_9226(() -> class_2561.method_43470((String)"Random Number:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)"Range: 0 to 1000 (default)").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + randomNumber)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static double calculateExpression(String expression) throws Exception {
        while (expression.contains("(")) {
            Matcher matcher = PARENTHESES_PATTERN.matcher(expression);
            if (matcher.find()) {
                String innerExpression = matcher.group(1);
                double innerResult = CalculatorCommand.calculateSimpleExpression(innerExpression);
                expression = expression.replace(matcher.group(0), String.valueOf(innerResult));
                continue;
            }
            throw new Exception("Mismatched parentheses");
        }
        return CalculatorCommand.calculateSimpleExpression(expression);
    }

    private static double calculateSimpleExpression(String expression) throws Exception {
        Matcher matcher = MATH_PATTERN.matcher(expression.trim());
        if (!matcher.matches()) {
            throw new Exception("Invalid format");
        }
        double num1 = Double.parseDouble(matcher.group(1));
        String operator = matcher.group(2);
        double num2 = Double.parseDouble(matcher.group(3));
        switch (operator) {
            case "+": {
                return num1 + num2;
            }
            case "-": {
                return num1 - num2;
            }
            case "*": {
                return num1 * num2;
            }
            case "/": {
                if (num2 == 0.0) {
                    throw new Exception("Division by zero");
                }
                return num1 / num2;
            }
        }
        throw new Exception("Unknown operator");
    }

    private static String formatResult(double result) {
        if (result == (double)((long)result)) {
            return String.format("%.0f", result);
        }
        return String.format("%.6f", result).replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    private static String formatCoord(double coord) {
        return String.format("%.1f", coord);
    }

    private static int getItemStackSize(String itemName) {
        try {
            class_1792 item;
            class_2960 itemId = class_2960.method_12829((String)itemName);
            if (itemId == null) {
                itemId = class_2960.method_60655((String)"minecraft", (String)itemName);
            }
            if ((item = (class_1792)class_7923.field_41178.method_63535(itemId)) != null) {
                return item.method_7882();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    static {
        HashMap<String, Integer> chestRecipe = new HashMap<String, Integer>();
        chestRecipe.put("oak_planks", 8);
        CRAFTING_RECIPES.put("chest", chestRecipe);
        HashMap<String, Integer> stickRecipe = new HashMap<String, Integer>();
        stickRecipe.put("oak_planks", 2);
        CRAFTING_RECIPES.put("stick", stickRecipe);
        HashMap<String, Integer> craftingTableRecipe = new HashMap<String, Integer>();
        craftingTableRecipe.put("oak_planks", 4);
        CRAFTING_RECIPES.put("crafting_table", craftingTableRecipe);
        HashMap<String, Integer> furnaceRecipe = new HashMap<String, Integer>();
        furnaceRecipe.put("cobblestone", 8);
        CRAFTING_RECIPES.put("furnace", furnaceRecipe);
        HashMap<String, Integer> ironPickaxeRecipe = new HashMap<String, Integer>();
        ironPickaxeRecipe.put("iron_ingot", 3);
        ironPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("iron_pickaxe", ironPickaxeRecipe);
        HashMap<String, Integer> diamondPickaxeRecipe = new HashMap<String, Integer>();
        diamondPickaxeRecipe.put("diamond", 3);
        diamondPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("diamond_pickaxe", diamondPickaxeRecipe);
    }
}

