/*
 * Decompiled with CFR 0.152.
 */
package com.hindustani_gamer_fardinigcalculator;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CalculatorCommand {
    private static final Pattern MATH_PATTERN = Pattern.compile("^(-?\\d+(?:\\.\\d+)?)\\s*([+\\-*/])\\s*(-?\\d+(?:\\.\\d+)?)$");
    private static final Pattern PARENTHESES_PATTERN = Pattern.compile("\\(([^()]+)\\)");
    private static final Random RANDOM = new Random();
    private static final Map<String, Map<String, Integer>> CRAFTING_RECIPES = new HashMap<String, Map<String, Integer>>();

    private static void initializeBasicRecipes() {
        HashMap<String, Integer> chestRecipe = new HashMap<String, Integer>();
        chestRecipe.put("oak_planks", 8);
        CRAFTING_RECIPES.put("chest", chestRecipe);
        HashMap<String, Integer> stickRecipe = new HashMap<String, Integer>();
        stickRecipe.put("oak_planks", 2);
        CRAFTING_RECIPES.put("stick", stickRecipe);
        HashMap<String, Integer> craftingTableRecipe = new HashMap<String, Integer>();
        craftingTableRecipe.put("oak_planks", 4);
        CRAFTING_RECIPES.put("crafting_table", craftingTableRecipe);
        HashMap<String, Integer> furnaceRecipe = new HashMap<String, Integer>();
        furnaceRecipe.put("cobblestone", 8);
        CRAFTING_RECIPES.put("furnace", furnaceRecipe);
    }

    private static void initializeToolRecipes() {
        HashMap<String, Integer> woodenPickaxeRecipe = new HashMap<String, Integer>();
        woodenPickaxeRecipe.put("planks", 3);
        woodenPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("wooden_pickaxe", woodenPickaxeRecipe);
        HashMap<String, Integer> woodenAxeRecipe = new HashMap<String, Integer>();
        woodenAxeRecipe.put("planks", 3);
        woodenAxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("wooden_axe", woodenAxeRecipe);
        HashMap<String, Integer> woodenShovelRecipe = new HashMap<String, Integer>();
        woodenShovelRecipe.put("planks", 1);
        woodenShovelRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("wooden_shovel", woodenShovelRecipe);
        HashMap<String, Integer> woodenHoeRecipe = new HashMap<String, Integer>();
        woodenHoeRecipe.put("planks", 2);
        woodenHoeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("wooden_hoe", woodenHoeRecipe);
        HashMap<String, Integer> woodenSwordRecipe = new HashMap<String, Integer>();
        woodenSwordRecipe.put("planks", 2);
        woodenSwordRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("wooden_sword", woodenSwordRecipe);
        HashMap<String, Integer> stonePickaxeRecipe = new HashMap<String, Integer>();
        stonePickaxeRecipe.put("cobblestone", 3);
        stonePickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("stone_pickaxe", stonePickaxeRecipe);
        HashMap<String, Integer> stoneAxeRecipe = new HashMap<String, Integer>();
        stoneAxeRecipe.put("cobblestone", 3);
        stoneAxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("stone_axe", stoneAxeRecipe);
        HashMap<String, Integer> stoneShovelRecipe = new HashMap<String, Integer>();
        stoneShovelRecipe.put("cobblestone", 1);
        stoneShovelRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("stone_shovel", stoneShovelRecipe);
        HashMap<String, Integer> stoneHoeRecipe = new HashMap<String, Integer>();
        stoneHoeRecipe.put("cobblestone", 2);
        stoneHoeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("stone_hoe", stoneHoeRecipe);
        HashMap<String, Integer> stoneSwordRecipe = new HashMap<String, Integer>();
        stoneSwordRecipe.put("cobblestone", 2);
        stoneSwordRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("stone_sword", stoneSwordRecipe);
        HashMap<String, Integer> ironPickaxeRecipe = new HashMap<String, Integer>();
        ironPickaxeRecipe.put("iron_ingot", 3);
        ironPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("iron_pickaxe", ironPickaxeRecipe);
        HashMap<String, Integer> ironAxeRecipe = new HashMap<String, Integer>();
        ironAxeRecipe.put("iron_ingot", 3);
        ironAxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("iron_axe", ironAxeRecipe);
        HashMap<String, Integer> ironShovelRecipe = new HashMap<String, Integer>();
        ironShovelRecipe.put("iron_ingot", 1);
        ironShovelRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("iron_shovel", ironShovelRecipe);
        HashMap<String, Integer> ironHoeRecipe = new HashMap<String, Integer>();
        ironHoeRecipe.put("iron_ingot", 2);
        ironHoeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("iron_hoe", ironHoeRecipe);
        HashMap<String, Integer> ironSwordRecipe = new HashMap<String, Integer>();
        ironSwordRecipe.put("iron_ingot", 2);
        ironSwordRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("iron_sword", ironSwordRecipe);
        HashMap<String, Integer> goldenPickaxeRecipe = new HashMap<String, Integer>();
        goldenPickaxeRecipe.put("gold_ingot", 3);
        goldenPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("golden_pickaxe", goldenPickaxeRecipe);
        HashMap<String, Integer> goldenAxeRecipe = new HashMap<String, Integer>();
        goldenAxeRecipe.put("gold_ingot", 3);
        goldenAxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("golden_axe", goldenAxeRecipe);
        HashMap<String, Integer> goldenShovelRecipe = new HashMap<String, Integer>();
        goldenShovelRecipe.put("gold_ingot", 1);
        goldenShovelRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("golden_shovel", goldenShovelRecipe);
        HashMap<String, Integer> goldenHoeRecipe = new HashMap<String, Integer>();
        goldenHoeRecipe.put("gold_ingot", 2);
        goldenHoeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("golden_hoe", goldenHoeRecipe);
        HashMap<String, Integer> goldenSwordRecipe = new HashMap<String, Integer>();
        goldenSwordRecipe.put("gold_ingot", 2);
        goldenSwordRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("golden_sword", goldenSwordRecipe);
        HashMap<String, Integer> diamondPickaxeRecipe = new HashMap<String, Integer>();
        diamondPickaxeRecipe.put("diamond", 3);
        diamondPickaxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("diamond_pickaxe", diamondPickaxeRecipe);
        HashMap<String, Integer> diamondAxeRecipe = new HashMap<String, Integer>();
        diamondAxeRecipe.put("diamond", 3);
        diamondAxeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("diamond_axe", diamondAxeRecipe);
        HashMap<String, Integer> diamondShovelRecipe = new HashMap<String, Integer>();
        diamondShovelRecipe.put("diamond", 1);
        diamondShovelRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("diamond_shovel", diamondShovelRecipe);
        HashMap<String, Integer> diamondHoeRecipe = new HashMap<String, Integer>();
        diamondHoeRecipe.put("diamond", 2);
        diamondHoeRecipe.put("stick", 2);
        CRAFTING_RECIPES.put("diamond_hoe", diamondHoeRecipe);
        HashMap<String, Integer> diamondSwordRecipe = new HashMap<String, Integer>();
        diamondSwordRecipe.put("diamond", 2);
        diamondSwordRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("diamond_sword", diamondSwordRecipe);
        HashMap<String, Integer> netheritePickaxeRecipe = new HashMap<String, Integer>();
        netheritePickaxeRecipe.put("diamond_pickaxe", 1);
        netheritePickaxeRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_pickaxe", netheritePickaxeRecipe);
        HashMap<String, Integer> netheriteAxeRecipe = new HashMap<String, Integer>();
        netheriteAxeRecipe.put("diamond_axe", 1);
        netheriteAxeRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_axe", netheriteAxeRecipe);
        HashMap<String, Integer> netheriteShovelRecipe = new HashMap<String, Integer>();
        netheriteShovelRecipe.put("diamond_shovel", 1);
        netheriteShovelRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_shovel", netheriteShovelRecipe);
        HashMap<String, Integer> netheriteHoeRecipe = new HashMap<String, Integer>();
        netheriteHoeRecipe.put("diamond_hoe", 1);
        netheriteHoeRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_hoe", netheriteHoeRecipe);
        HashMap<String, Integer> netheriteSwordRecipe = new HashMap<String, Integer>();
        netheriteSwordRecipe.put("diamond_sword", 1);
        netheriteSwordRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_sword", netheriteSwordRecipe);
    }

    private static void initializeArmorRecipes() {
        HashMap<String, Integer> leatherHelmetRecipe = new HashMap<String, Integer>();
        leatherHelmetRecipe.put("leather", 5);
        CRAFTING_RECIPES.put("leather_helmet", leatherHelmetRecipe);
        HashMap<String, Integer> leatherChestplateRecipe = new HashMap<String, Integer>();
        leatherChestplateRecipe.put("leather", 8);
        CRAFTING_RECIPES.put("leather_chestplate", leatherChestplateRecipe);
        HashMap<String, Integer> leatherLeggingsRecipe = new HashMap<String, Integer>();
        leatherLeggingsRecipe.put("leather", 7);
        CRAFTING_RECIPES.put("leather_leggings", leatherLeggingsRecipe);
        HashMap<String, Integer> leatherBootsRecipe = new HashMap<String, Integer>();
        leatherBootsRecipe.put("leather", 4);
        CRAFTING_RECIPES.put("leather_boots", leatherBootsRecipe);
        HashMap<String, Integer> ironHelmetRecipe = new HashMap<String, Integer>();
        ironHelmetRecipe.put("iron_ingot", 5);
        CRAFTING_RECIPES.put("iron_helmet", ironHelmetRecipe);
        HashMap<String, Integer> ironChestplateRecipe = new HashMap<String, Integer>();
        ironChestplateRecipe.put("iron_ingot", 8);
        CRAFTING_RECIPES.put("iron_chestplate", ironChestplateRecipe);
        HashMap<String, Integer> ironLeggingsRecipe = new HashMap<String, Integer>();
        ironLeggingsRecipe.put("iron_ingot", 7);
        CRAFTING_RECIPES.put("iron_leggings", ironLeggingsRecipe);
        HashMap<String, Integer> ironBootsRecipe = new HashMap<String, Integer>();
        ironBootsRecipe.put("iron_ingot", 4);
        CRAFTING_RECIPES.put("iron_boots", ironBootsRecipe);
        HashMap<String, Integer> goldenHelmetRecipe = new HashMap<String, Integer>();
        goldenHelmetRecipe.put("gold_ingot", 5);
        CRAFTING_RECIPES.put("golden_helmet", goldenHelmetRecipe);
        HashMap<String, Integer> goldenChestplateRecipe = new HashMap<String, Integer>();
        goldenChestplateRecipe.put("gold_ingot", 8);
        CRAFTING_RECIPES.put("golden_chestplate", goldenChestplateRecipe);
        HashMap<String, Integer> goldenLeggingsRecipe = new HashMap<String, Integer>();
        goldenLeggingsRecipe.put("gold_ingot", 7);
        CRAFTING_RECIPES.put("golden_leggings", goldenLeggingsRecipe);
        HashMap<String, Integer> goldenBootsRecipe = new HashMap<String, Integer>();
        goldenBootsRecipe.put("gold_ingot", 4);
        CRAFTING_RECIPES.put("golden_boots", goldenBootsRecipe);
        HashMap<String, Integer> diamondHelmetRecipe = new HashMap<String, Integer>();
        diamondHelmetRecipe.put("diamond", 5);
        CRAFTING_RECIPES.put("diamond_helmet", diamondHelmetRecipe);
        HashMap<String, Integer> diamondChestplateRecipe = new HashMap<String, Integer>();
        diamondChestplateRecipe.put("diamond", 8);
        CRAFTING_RECIPES.put("diamond_chestplate", diamondChestplateRecipe);
        HashMap<String, Integer> diamondLeggingsRecipe = new HashMap<String, Integer>();
        diamondLeggingsRecipe.put("diamond", 7);
        CRAFTING_RECIPES.put("diamond_leggings", diamondLeggingsRecipe);
        HashMap<String, Integer> diamondBootsRecipe = new HashMap<String, Integer>();
        diamondBootsRecipe.put("diamond", 4);
        CRAFTING_RECIPES.put("diamond_boots", diamondBootsRecipe);
        HashMap<String, Integer> netheriteHelmetRecipe = new HashMap<String, Integer>();
        netheriteHelmetRecipe.put("diamond_helmet", 1);
        netheriteHelmetRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_helmet", netheriteHelmetRecipe);
        HashMap<String, Integer> netheriteChestplateRecipe = new HashMap<String, Integer>();
        netheriteChestplateRecipe.put("diamond_chestplate", 1);
        netheriteChestplateRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_chestplate", netheriteChestplateRecipe);
        HashMap<String, Integer> netheriteLeggingsRecipe = new HashMap<String, Integer>();
        netheriteLeggingsRecipe.put("diamond_leggings", 1);
        netheriteLeggingsRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_leggings", netheriteLeggingsRecipe);
        HashMap<String, Integer> netheriteBootsRecipe = new HashMap<String, Integer>();
        netheriteBootsRecipe.put("diamond_boots", 1);
        netheriteBootsRecipe.put("netherite_ingot", 1);
        CRAFTING_RECIPES.put("netherite_boots", netheriteBootsRecipe);
    }

    private static void initializeRedstoneRecipes() {
        HashMap<String, Integer> pistonRecipe = new HashMap<String, Integer>();
        pistonRecipe.put("cobblestone", 4);
        pistonRecipe.put("iron_ingot", 1);
        pistonRecipe.put("redstone", 1);
        pistonRecipe.put("planks", 3);
        CRAFTING_RECIPES.put("piston", pistonRecipe);
        HashMap<String, Integer> stickyPistonRecipe = new HashMap<String, Integer>();
        stickyPistonRecipe.put("piston", 1);
        stickyPistonRecipe.put("slime_ball", 1);
        CRAFTING_RECIPES.put("sticky_piston", stickyPistonRecipe);
        HashMap<String, Integer> redstoneRepeaterRecipe = new HashMap<String, Integer>();
        redstoneRepeaterRecipe.put("redstone", 1);
        redstoneRepeaterRecipe.put("redstone_torch", 2);
        redstoneRepeaterRecipe.put("stone", 3);
        CRAFTING_RECIPES.put("repeater", redstoneRepeaterRecipe);
        HashMap<String, Integer> redstoneComparatorRecipe = new HashMap<String, Integer>();
        redstoneComparatorRecipe.put("redstone_torch", 3);
        redstoneComparatorRecipe.put("quartz", 1);
        redstoneComparatorRecipe.put("stone", 3);
        CRAFTING_RECIPES.put("comparator", redstoneComparatorRecipe);
        HashMap<String, Integer> redstoneTorchRecipe = new HashMap<String, Integer>();
        redstoneTorchRecipe.put("redstone", 1);
        redstoneTorchRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("redstone_torch", redstoneTorchRecipe);
        HashMap<String, Integer> leverRecipe = new HashMap<String, Integer>();
        leverRecipe.put("cobblestone", 1);
        leverRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("lever", leverRecipe);
        HashMap<String, Integer> observerRecipe = new HashMap<String, Integer>();
        observerRecipe.put("cobblestone", 6);
        observerRecipe.put("redstone", 1);
        observerRecipe.put("quartz", 1);
        CRAFTING_RECIPES.put("observer", observerRecipe);
        HashMap<String, Integer> hopperRecipe = new HashMap<String, Integer>();
        hopperRecipe.put("iron_ingot", 5);
        hopperRecipe.put("chest", 1);
        CRAFTING_RECIPES.put("hopper", hopperRecipe);
        HashMap<String, Integer> dropperRecipe = new HashMap<String, Integer>();
        dropperRecipe.put("cobblestone", 7);
        dropperRecipe.put("redstone", 1);
        CRAFTING_RECIPES.put("dropper", dropperRecipe);
        HashMap<String, Integer> dispenserRecipe = new HashMap<String, Integer>();
        dispenserRecipe.put("cobblestone", 7);
        dispenserRecipe.put("redstone", 1);
        dispenserRecipe.put("bow", 1);
        CRAFTING_RECIPES.put("dispenser", dispenserRecipe);
    }

    private static void initializeTransportationRecipes() {
        HashMap<String, Integer> minecartRecipe = new HashMap<String, Integer>();
        minecartRecipe.put("iron_ingot", 5);
        CRAFTING_RECIPES.put("minecart", minecartRecipe);
        HashMap<String, Integer> chestMinecartRecipe = new HashMap<String, Integer>();
        chestMinecartRecipe.put("minecart", 1);
        chestMinecartRecipe.put("chest", 1);
        CRAFTING_RECIPES.put("chest_minecart", chestMinecartRecipe);
        HashMap<String, Integer> furnaceMinecartRecipe = new HashMap<String, Integer>();
        furnaceMinecartRecipe.put("minecart", 1);
        furnaceMinecartRecipe.put("furnace", 1);
        CRAFTING_RECIPES.put("furnace_minecart", furnaceMinecartRecipe);
        HashMap<String, Integer> hopperMinecartRecipe = new HashMap<String, Integer>();
        hopperMinecartRecipe.put("minecart", 1);
        hopperMinecartRecipe.put("hopper", 1);
        CRAFTING_RECIPES.put("hopper_minecart", hopperMinecartRecipe);
        HashMap<String, Integer> railRecipe = new HashMap<String, Integer>();
        railRecipe.put("iron_ingot", 6);
        railRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("rail", railRecipe);
        HashMap<String, Integer> poweredRailRecipe = new HashMap<String, Integer>();
        poweredRailRecipe.put("gold_ingot", 6);
        poweredRailRecipe.put("stick", 1);
        poweredRailRecipe.put("redstone", 1);
        CRAFTING_RECIPES.put("powered_rail", poweredRailRecipe);
        HashMap<String, Integer> detectorRailRecipe = new HashMap<String, Integer>();
        detectorRailRecipe.put("iron_ingot", 6);
        detectorRailRecipe.put("stone_pressure_plate", 1);
        detectorRailRecipe.put("redstone", 1);
        CRAFTING_RECIPES.put("detector_rail", detectorRailRecipe);
        HashMap<String, Integer> activatorRailRecipe = new HashMap<String, Integer>();
        activatorRailRecipe.put("iron_ingot", 6);
        activatorRailRecipe.put("stick", 1);
        activatorRailRecipe.put("redstone_torch", 1);
        CRAFTING_RECIPES.put("activator_rail", activatorRailRecipe);
        HashMap<String, Integer> boatRecipe = new HashMap<String, Integer>();
        boatRecipe.put("oak_planks", 5);
        CRAFTING_RECIPES.put("oak_boat", boatRecipe);
    }

    private static void initializeDecorativeRecipes() {
        HashMap<String, Integer> glassRecipe = new HashMap<String, Integer>();
        glassRecipe.put("sand", 1);
        CRAFTING_RECIPES.put("glass", glassRecipe);
        HashMap<String, Integer> glassPane = new HashMap<String, Integer>();
        glassPane.put("glass", 6);
        CRAFTING_RECIPES.put("glass_pane", glassPane);
        HashMap<String, Integer> bookshelfRecipe = new HashMap<String, Integer>();
        bookshelfRecipe.put("planks", 6);
        bookshelfRecipe.put("book", 3);
        CRAFTING_RECIPES.put("bookshelf", bookshelfRecipe);
        HashMap<String, Integer> lanternRecipe = new HashMap<String, Integer>();
        lanternRecipe.put("iron_nugget", 8);
        lanternRecipe.put("torch", 1);
        CRAFTING_RECIPES.put("lantern", lanternRecipe);
        HashMap<String, Integer> torchRecipe = new HashMap<String, Integer>();
        torchRecipe.put("coal", 1);
        torchRecipe.put("stick", 1);
        CRAFTING_RECIPES.put("torch", torchRecipe);
    }

    private static void initializeFoodRecipes() {
        HashMap<String, Integer> breadRecipe = new HashMap<String, Integer>();
        breadRecipe.put("wheat", 3);
        CRAFTING_RECIPES.put("bread", breadRecipe);
        HashMap<String, Integer> cakeRecipe = new HashMap<String, Integer>();
        cakeRecipe.put("milk_bucket", 3);
        cakeRecipe.put("sugar", 2);
        cakeRecipe.put("wheat", 3);
        cakeRecipe.put("egg", 1);
        CRAFTING_RECIPES.put("cake", cakeRecipe);
        HashMap<String, Integer> cookieRecipe = new HashMap<String, Integer>();
        cookieRecipe.put("wheat", 2);
        cookieRecipe.put("cocoa_beans", 1);
        CRAFTING_RECIPES.put("cookie", cookieRecipe);
        HashMap<String, Integer> goldenAppleRecipe = new HashMap<String, Integer>();
        goldenAppleRecipe.put("apple", 1);
        goldenAppleRecipe.put("gold_ingot", 8);
        CRAFTING_RECIPES.put("golden_apple", goldenAppleRecipe);
    }

    private static void initializeMiscRecipes() {
        HashMap<String, Integer> barrelRecipe = new HashMap<String, Integer>();
        barrelRecipe.put("planks", 6);
        barrelRecipe.put("wooden_slab", 2);
        CRAFTING_RECIPES.put("barrel", barrelRecipe);
        HashMap<String, Integer> shulkerBoxRecipe = new HashMap<String, Integer>();
        shulkerBoxRecipe.put("shulker_shell", 2);
        shulkerBoxRecipe.put("chest", 1);
        CRAFTING_RECIPES.put("shulker_box", shulkerBoxRecipe);
        HashMap<String, Integer> beaconRecipe = new HashMap<String, Integer>();
        beaconRecipe.put("glass", 5);
        beaconRecipe.put("obsidian", 3);
        beaconRecipe.put("nether_star", 1);
        CRAFTING_RECIPES.put("beacon", beaconRecipe);
        HashMap<String, Integer> enderChestRecipe = new HashMap<String, Integer>();
        enderChestRecipe.put("obsidian", 8);
        enderChestRecipe.put("eye_of_ender", 1);
        CRAFTING_RECIPES.put("ender_chest", enderChestRecipe);
        HashMap<String, Integer> bowRecipe = new HashMap<String, Integer>();
        bowRecipe.put("stick", 3);
        bowRecipe.put("string", 3);
        CRAFTING_RECIPES.put("bow", bowRecipe);
        HashMap<String, Integer> crossbowRecipe = new HashMap<String, Integer>();
        crossbowRecipe.put("stick", 3);
        crossbowRecipe.put("string", 2);
        crossbowRecipe.put("iron_ingot", 1);
        crossbowRecipe.put("tripwire_hook", 1);
        CRAFTING_RECIPES.put("crossbow", crossbowRecipe);
        HashMap<String, Integer> shieldRecipe = new HashMap<String, Integer>();
        shieldRecipe.put("planks", 6);
        shieldRecipe.put("iron_ingot", 1);
        CRAFTING_RECIPES.put("shield", shieldRecipe);
        HashMap<String, Integer> arrowRecipe = new HashMap<String, Integer>();
        arrowRecipe.put("flint", 1);
        arrowRecipe.put("stick", 1);
        arrowRecipe.put("feather", 1);
        CRAFTING_RECIPES.put("arrow", arrowRecipe);
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder calculator = class_2170.method_9247((String)"calculator");
        LiteralArgumentBuilder help = (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(CalculatorCommand::executeHelp);
        calculator.then((ArgumentBuilder)help);
        calculator.then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(CalculatorCommand::execute));
        LiteralArgumentBuilder craft = class_2170.method_9247((String)"craft");
        LiteralArgumentBuilder craftHelp = (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(CalculatorCommand::executeCraftHelp);
        craft.then((ArgumentBuilder)craftHelp);
        craft.then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"quantity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeCraftRecipe)));
        calculator.then((ArgumentBuilder)craft);
        craft.then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"quantity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeCraftRecipe)));
        calculator.then((ArgumentBuilder)craft);
        LiteralArgumentBuilder stack = class_2170.method_9247((String)"stack");
        stack.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9247((String)"sb").executes(CalculatorCommand::executeStackShulker))).executes(CalculatorCommand::executeStack));
        calculator.then((ArgumentBuilder)stack);
        LiteralArgumentBuilder nether = class_2170.method_9247((String)"nether");
        nether.then(class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"y", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word()).executes(context -> {
            double z;
            double y;
            double x;
            String xStr = StringArgumentType.getString((CommandContext)context, (String)"x");
            String yStr = StringArgumentType.getString((CommandContext)context, (String)"y");
            String zStr = StringArgumentType.getString((CommandContext)context, (String)"z");
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
                return 0;
            }
            class_3222 player = source.method_9207();
            class_2338 playerPos = player.method_24515();
            try {
                x = xStr.equals("~") ? (double)playerPos.method_10263() : Double.parseDouble(xStr);
                y = yStr.equals("~") ? (double)playerPos.method_10264() : Double.parseDouble(yStr);
                z = zStr.equals("~") ? (double)playerPos.method_10260() : Double.parseDouble(zStr);
            }
            catch (NumberFormatException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid coordinates! Use numbers or ~ for current position.").method_27692(class_124.field_1061));
                return 0;
            }
            double netherX = x / 8.0;
            double netherZ = z / 8.0;
            source.method_9226(() -> class_2561.method_43470((String)"Nether Coordinates:").method_27692(class_124.field_1065), false);
            source.method_9226(() -> class_2561.method_43470((String)("X: " + CalculatorCommand.formatCoord(netherX) + ", Y: " + CalculatorCommand.formatCoord(y) + ", Z: " + CalculatorCommand.formatCoord(netherZ))).method_27692(class_124.field_1054), false);
            return 1;
        }))));
        nether.executes(CalculatorCommand::executeNetherCurrent);
        calculator.then((ArgumentBuilder)nether);
        LiteralArgumentBuilder overworld = class_2170.method_9247((String)"overworld");
        overworld.then(class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"y", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word()).executes(CalculatorCommand::executeOverworldCoords))));
        overworld.executes(CalculatorCommand::executeOverworld);
        calculator.then((ArgumentBuilder)overworld);
        LiteralArgumentBuilder hoppertimer = class_2170.method_9247((String)"hoppertimer");
        hoppertimer.then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeHopperTimer));
        calculator.then((ArgumentBuilder)hoppertimer);
        LiteralArgumentBuilder hoppertimerticks = class_2170.method_9247((String)"hoppertimerticks");
        hoppertimerticks.then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeHopperTimerTicks));
        calculator.then((ArgumentBuilder)hoppertimerticks);
        LiteralArgumentBuilder distance = class_2170.method_9247((String)"distance");
        distance.then(class_2170.method_9244((String)"x1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"x2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeDistance)))))));
        distance.executes(CalculatorCommand::executeDistanceFromCurrent);
        calculator.then((ArgumentBuilder)distance);
        LiteralArgumentBuilder area = class_2170.method_9247((String)"area");
        area.then(class_2170.method_9244((String)"length", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeArea)));
        calculator.then((ArgumentBuilder)area);
        LiteralArgumentBuilder volume = class_2170.method_9247((String)"volume");
        volume.then(class_2170.method_9244((String)"length", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeVolume))));
        calculator.then((ArgumentBuilder)volume);
        LiteralArgumentBuilder square = (LiteralArgumentBuilder)class_2170.method_9247((String)"sq").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSquare));
        calculator.then((ArgumentBuilder)square);
        LiteralArgumentBuilder cube = (LiteralArgumentBuilder)class_2170.method_9247((String)"cube").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeCube));
        calculator.then((ArgumentBuilder)cube);
        LiteralArgumentBuilder power = class_2170.method_9247((String)"power");
        power.then(class_2170.method_9244((String)"base", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"exponent", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executePower)));
        calculator.then((ArgumentBuilder)power);
        LiteralArgumentBuilder sqrt = (LiteralArgumentBuilder)class_2170.method_9247((String)"sqrt").then(class_2170.method_9244((String)"number", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSqrt));
        calculator.then((ArgumentBuilder)sqrt);
        LiteralArgumentBuilder secToTicks = class_2170.method_9247((String)"secToTicks");
        secToTicks.then(class_2170.method_9244((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg()).executes(CalculatorCommand::executeSecToTicks));
        calculator.then((ArgumentBuilder)secToTicks);
        LiteralArgumentBuilder tickToSec = class_2170.method_9247((String)"tickToSec");
        tickToSec.then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).executes(CalculatorCommand::executeTickToSec));
        calculator.then((ArgumentBuilder)tickToSec);
        LiteralArgumentBuilder random = class_2170.method_9247((String)"random");
        random.then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CalculatorCommand::executeRandom));
        random.executes(CalculatorCommand::executeRandomDefault);
        calculator.then((ArgumentBuilder)random);
        LiteralArgumentBuilder beacon = class_2170.method_9247((String)"beacon");
        beacon.then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).executes(CalculatorCommand::executeBeacon));
        calculator.then((ArgumentBuilder)beacon);
        LiteralArgumentBuilder beaconArea = class_2170.method_9247((String)"beacon_area");
        beaconArea.then(class_2170.method_9244((String)"x1", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y1", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"z1", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"x2", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y2", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"z2", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).executes(CalculatorCommand::executeBeaconArea))))))));
        calculator.then((ArgumentBuilder)beaconArea);
        dispatcher.register((LiteralArgumentBuilder)calculator.executes(CalculatorCommand::executeHelp));
    }

    private static int executeHelp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== IG Calculator Help ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"This mod allows you to perform calculations and conversions in-game!").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Basic Math:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator <number> <operator> <number>").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Operators: + - * / (supports parentheses)").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Example: /calculator (2+3) * 4").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Advanced Math:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator sq <number> - Square").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator cube <number> - Cube").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator power <base> <exponent> - Power").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator sqrt <number> - Square root").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator random [max] - Random number (default 0-1000)").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Stack Calculator:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator stack <amount> - Convert to stacks").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator stack <amount> sb - Include shulker boxes").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Geometry:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator area <width> <length> - Calculate area").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator volume <width> <length> <height> - Calculate volume").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator distance <x1> <y1> <z1> <x2> <y2> <z2> - Calculate distance").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Beacon Calculator:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator beacon <type> - Calculate beacon requirements").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator beacon_area <x1> <y1> <z1> <x2> <y2> <z2> <type> - Calculate beacons for area").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Types: small/1 (9x9 base) or large/2 (10x11 base)").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Minecraft Tools:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator nether [~ ~ ~] or [x y z] - Nether coordinates").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator overworld [~ ~ ~] or [x y z] - Overworld coordinates").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator hoppertimer <seconds> - Items needed for timer").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator hoppertimerticks <ticks> - Items needed for tick timer").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator secToTicks <seconds> - Convert seconds to ticks").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator tickToSec <ticks> - Convert ticks to seconds").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator craft <item> amount <quantity> - Crafting calculator").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  /calculator craft help - Show available crafting recipes").method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        String expression = StringArgumentType.getString(context, (String)"expression");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        try {
            double result = CalculatorCommand.calculateExpression(expression);
            String formattedResult = CalculatorCommand.formatResult(result);
            source.method_9226(() -> class_2561.method_43470((String)"Calculator Result: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(expression + " = " + formattedResult)).method_27692(class_124.field_1054)), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid expression! " + e.getMessage())).method_27692(class_124.field_1061));
            source.method_9226(() -> class_2561.method_43470((String)"Use ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"/calculator help").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" for detailed help.").method_27692(class_124.field_1080)), false);
            return 0;
        }
    }

    private static int executeCraftRecipe(CommandContext<class_2168> context) throws CommandSyntaxException {
        String itemName = StringArgumentType.getString(context, (String)"item");
        int quantity = IntegerArgumentType.getInteger(context, (String)"quantity");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        String cleanItemName = itemName.startsWith("minecraft:") ? itemName.substring(10) : itemName;
        Map<String, Integer> recipe = CRAFTING_RECIPES.get(cleanItemName);
        if (recipe == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No crafting recipe found for: " + cleanItemName)).method_27692(class_124.field_1061));
            source.method_9226(() -> class_2561.method_43470((String)("Available recipes: " + String.join((CharSequence)", ", CRAFTING_RECIPES.keySet()))).method_27692(class_124.field_1080), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Crafting Calculator ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Item: " + cleanItemName + " x" + quantity)).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        int totalItemsNeeded = 0;
        for (Map.Entry<String, Integer> ingredient : recipe.entrySet()) {
            String ingredientName = ingredient.getKey();
            int baseAmount = ingredient.getValue();
            int totalAmount = baseAmount * quantity;
            totalItemsNeeded += totalAmount;
            int stackSize = CalculatorCommand.getItemStackSize(ingredientName);
            if (stackSize == -1) {
                stackSize = 64;
            }
            int stacks = totalAmount / stackSize;
            int remainder = totalAmount % stackSize;
            String finalIngredientName = ingredientName;
            int finalBaseAmount = baseAmount;
            int finalTotalAmount = totalAmount;
            int finalStacks = stacks;
            int finalRemainder = remainder;
            source.method_9226(() -> class_2561.method_43470((String)(finalIngredientName + ": " + finalBaseAmount + " x " + quantity + " = " + finalTotalAmount + " \u2192 " + finalStacks + " stacks and " + finalRemainder + " items")).method_27692(class_124.field_1068), false);
        }
        int totalStacks = totalItemsNeeded / 64;
        int totalRemainder = totalItemsNeeded % 64;
        int finalTotalItemsNeeded = totalItemsNeeded;
        int finalTotalStacks = totalStacks;
        int finalTotalRemainder = totalRemainder;
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total items needed: " + finalTotalItemsNeeded + " \u2192 " + finalTotalStacks + " stacks and " + finalTotalRemainder + " items")).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeStack(CommandContext<class_2168> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int stacks = amount / 64;
        int remainder = amount % 64;
        source.method_9226(() -> class_2561.method_43470((String)"Stack Calculator:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Amount: " + amount + " items")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + stacks + " stacks and " + remainder + " items")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeStackShulker(CommandContext<class_2168> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int stacks = amount / 64;
        int remainder = amount % 64;
        int shulkerBoxes = (int)Math.ceil((double)stacks / 27.0);
        int remainingStacks = stacks % 27;
        source.method_9226(() -> class_2561.method_43470((String)"Shulker Box Calculator:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Amount: " + amount + " items")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + stacks + " stacks and " + remainder + " items")).method_27692(class_124.field_1054), false);
        if (shulkerBoxes > 0) {
            String shulkerText = shulkerBoxes == 1 ? "shulker box" : "shulker boxes";
            String stackText = remainingStacks == 1 ? "stack" : "stacks";
            source.method_9226(() -> class_2561.method_43470((String)("Shulker storage: " + shulkerBoxes + " " + shulkerText + " and " + remainingStacks + " " + stackText)).method_27692(class_124.field_1075), false);
        }
        return 1;
    }

    private static int executeOverworldCoords(CommandContext<class_2168> context) throws CommandSyntaxException {
        double z;
        double y;
        double x;
        String xStr = StringArgumentType.getString(context, (String)"x");
        String yStr = StringArgumentType.getString(context, (String)"y");
        String zStr = StringArgumentType.getString(context, (String)"z");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 playerPos = player.method_24515();
        try {
            x = xStr.equals("~") ? (double)playerPos.method_10263() : Double.parseDouble(xStr);
            y = yStr.equals("~") ? (double)playerPos.method_10264() : Double.parseDouble(yStr);
            z = zStr.equals("~") ? (double)playerPos.method_10260() : Double.parseDouble(zStr);
        }
        catch (NumberFormatException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid coordinates! Use numbers or ~ for current position.").method_27692(class_124.field_1061));
            return 0;
        }
        double overworldX = x * 8.0;
        double overworldZ = z * 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Overworld Coordinates:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Nether: " + CalculatorCommand.formatCoord(x) + ", " + CalculatorCommand.formatCoord(y) + ", " + CalculatorCommand.formatCoord(z))).method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Overworld: " + CalculatorCommand.formatCoord(overworldX) + ", " + CalculatorCommand.formatCoord(y) + ", " + CalculatorCommand.formatCoord(overworldZ))).method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int executeNetherCurrent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 pos = player.method_24515();
        double netherX = (double)pos.method_10263() / 8.0;
        double netherZ = (double)pos.method_10260() / 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Nether Coordinates:").method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Current Overworld: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Nether: " + CalculatorCommand.formatCoord(netherX) + ", " + pos.method_10264() + ", " + CalculatorCommand.formatCoord(netherZ))).method_27692(class_124.field_1065), false);
        return 1;
    }

    private static int executeOverworld(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        class_3222 player = source.method_9207();
        class_2338 pos = player.method_24515();
        double overworldX = (double)pos.method_10263() * 8.0;
        double overworldZ = (double)pos.method_10260() * 8.0;
        source.method_9226(() -> class_2561.method_43470((String)"Overworld Coordinates:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Current Nether: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1061), false);
        source.method_9226(() -> class_2561.method_43470((String)("Overworld: " + CalculatorCommand.formatCoord(overworldX) + ", " + pos.method_10264() + ", " + CalculatorCommand.formatCoord(overworldZ))).method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int executeHopperTimer(CommandContext<class_2168> context) throws CommandSyntaxException {
        int seconds = IntegerArgumentType.getInteger(context, (String)"seconds");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int ticks = seconds * 20;
        int items = (int)Math.ceil((double)ticks / 8.0);
        source.method_9226(() -> class_2561.method_43470((String)"Hopper Timer:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Time: " + seconds + " seconds (" + ticks + " ticks)")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Items needed in hopper: " + items)).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeHopperTimerTicks(CommandContext<class_2168> context) throws CommandSyntaxException {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double seconds = (double)ticks / 20.0;
        int items = (int)Math.ceil((double)ticks / 8.0);
        source.method_9226(() -> class_2561.method_43470((String)"Hopper Timer:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Time: " + ticks + " ticks (" + CalculatorCommand.formatResult(seconds) + " seconds)")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Items needed in hopper: " + items)).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static int executeDistance(CommandContext<class_2168> context) throws CommandSyntaxException {
        double x1 = DoubleArgumentType.getDouble(context, (String)"x1");
        double y1 = DoubleArgumentType.getDouble(context, (String)"y1");
        double z1 = DoubleArgumentType.getDouble(context, (String)"z1");
        double x2 = DoubleArgumentType.getDouble(context, (String)"x2");
        double y2 = DoubleArgumentType.getDouble(context, (String)"y2");
        double z2 = DoubleArgumentType.getDouble(context, (String)"z2");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double distance = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        source.method_9226(() -> class_2561.method_43470((String)"Distance Calculation:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("From: (" + CalculatorCommand.formatCoord(x1) + ", " + CalculatorCommand.formatCoord(y1) + ", " + CalculatorCommand.formatCoord(z1) + ")")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("To: (" + CalculatorCommand.formatCoord(x2) + ", " + CalculatorCommand.formatCoord(y2) + ", " + CalculatorCommand.formatCoord(z2) + ")")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Distance: " + CalculatorCommand.formatResult(distance) + " blocks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeDistanceFromCurrent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Please specify target coordinates: /calculator distance <x1> <y1> <z1> <x2> <y2> <z2>").method_27692(class_124.field_1061));
        return 0;
    }

    private static int executeArea(CommandContext<class_2168> context) throws CommandSyntaxException {
        double length = DoubleArgumentType.getDouble(context, (String)"length");
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double area = length * width;
        source.method_9226(() -> class_2561.method_43470((String)"Area Calculation:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Length: " + CalculatorCommand.formatResult(length) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + CalculatorCommand.formatResult(width) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Area: " + CalculatorCommand.formatResult(area) + " blocks\u00b2")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeVolume(CommandContext<class_2168> context) throws CommandSyntaxException {
        double length = DoubleArgumentType.getDouble(context, (String)"length");
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double volume = length * width * height;
        source.method_9226(() -> class_2561.method_43470((String)"Volume Calculation:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("Length: " + CalculatorCommand.formatResult(length) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + CalculatorCommand.formatResult(width) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Height: " + CalculatorCommand.formatResult(height) + " blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Volume: " + CalculatorCommand.formatResult(volume) + " blocks\u00b3")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSquare(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = number * number;
        source.method_9226(() -> class_2561.method_43470((String)"Square Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(number) + "\u00b2 = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeCube(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = number * number * number;
        source.method_9226(() -> class_2561.method_43470((String)"Cube Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(number) + "\u00b3 = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executePower(CommandContext<class_2168> context) throws CommandSyntaxException {
        double base = DoubleArgumentType.getDouble(context, (String)"base");
        double exponent = DoubleArgumentType.getDouble(context, (String)"exponent");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = Math.pow(base, exponent);
        source.method_9226(() -> class_2561.method_43470((String)"Power Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(base) + "^" + CalculatorCommand.formatResult(exponent) + " = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSqrt(CommandContext<class_2168> context) throws CommandSyntaxException {
        double number = DoubleArgumentType.getDouble(context, (String)"number");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        if (number < 0.0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot calculate square root of negative number!").method_27692(class_124.field_1061));
            return 0;
        }
        double result = Math.sqrt(number);
        source.method_9226(() -> class_2561.method_43470((String)"Square Root Calculation:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u221a" + CalculatorCommand.formatResult(number) + " = " + CalculatorCommand.formatResult(result))).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeSecToTicks(CommandContext<class_2168> context) throws CommandSyntaxException {
        double seconds = DoubleArgumentType.getDouble(context, (String)"seconds");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double ticks = seconds * 20.0;
        source.method_9226(() -> class_2561.method_43470((String)"Time Conversion:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)(CalculatorCommand.formatResult(seconds) + " seconds = " + CalculatorCommand.formatResult(ticks) + " ticks")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeTickToSec(CommandContext<class_2168> context) throws CommandSyntaxException {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        double seconds = (double)ticks / 20.0;
        source.method_9226(() -> class_2561.method_43470((String)"Time Conversion:").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)(ticks + " ticks = " + CalculatorCommand.formatResult(seconds) + " seconds")).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeRandom(CommandContext<class_2168> context) throws CommandSyntaxException {
        int max = IntegerArgumentType.getInteger(context, (String)"max");
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int randomNumber = RANDOM.nextInt(max + 1);
        source.method_9226(() -> class_2561.method_43470((String)"Random Number:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)("Range: 0 to " + max)).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + randomNumber)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int executeRandomDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int randomNumber = RANDOM.nextInt(1001);
        source.method_9226(() -> class_2561.method_43470((String)"Random Number:").method_27692(class_124.field_1076), false);
        source.method_9226(() -> class_2561.method_43470((String)"Range: 0 to 1000 (default)").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("Result: " + randomNumber)).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static double calculateExpression(String expression) throws Exception {
        while (expression.contains("(")) {
            Matcher matcher = PARENTHESES_PATTERN.matcher(expression);
            if (matcher.find()) {
                String innerExpression = matcher.group(1);
                double innerResult = CalculatorCommand.calculateSimpleExpression(innerExpression);
                expression = expression.replace(matcher.group(0), String.valueOf(innerResult));
                continue;
            }
            throw new Exception("Mismatched parentheses");
        }
        return CalculatorCommand.calculateSimpleExpression(expression);
    }

    private static double calculateSimpleExpression(String expression) throws Exception {
        Matcher matcher = MATH_PATTERN.matcher(expression.trim());
        if (!matcher.matches()) {
            throw new Exception("Invalid format");
        }
        double num1 = Double.parseDouble(matcher.group(1));
        String operator = matcher.group(2);
        double num2 = Double.parseDouble(matcher.group(3));
        switch (operator) {
            case "+": {
                return num1 + num2;
            }
            case "-": {
                return num1 - num2;
            }
            case "*": {
                return num1 * num2;
            }
            case "/": {
                if (num2 == 0.0) {
                    throw new Exception("Division by zero");
                }
                return num1 / num2;
            }
        }
        throw new Exception("Unknown operator");
    }

    private static String formatResult(double result) {
        if (result == (double)((long)result)) {
            return String.format("%.0f", result);
        }
        return String.format("%.6f", result).replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    private static String formatCoord(double coord) {
        return String.format("%.1f", coord);
    }

    private static int getItemStackSize(String itemName) {
        try {
            class_1792 item;
            class_2960 itemId = class_2960.method_12829((String)itemName);
            if (itemId == null) {
                itemId = class_2960.method_60655((String)"minecraft", (String)itemName);
            }
            if ((item = (class_1792)class_7923.field_41178.method_63535(itemId)) != null) {
                return item.method_7882();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static int executeBeacon(CommandContext<class_2168> context) throws CommandSyntaxException {
        String beaconType;
        int totalBlocks;
        int beaconBlocks;
        class_2168 source = (class_2168)context.getSource();
        String type = StringArgumentType.getString(context, (String)"type");
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        switch (type.toLowerCase()) {
            case "1": 
            case "small": 
            case "9x9": {
                beaconBlocks = 1;
                totalBlocks = 164;
                beaconType = "Small (9x9 base)";
                break;
            }
            case "2": 
            case "large": 
            case "10x11": {
                beaconBlocks = 6;
                totalBlocks = 244;
                beaconType = "Large (10x11 base)";
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid beacon type! Use '1' or 'small' for 9x9, '2' or 'large' for 10x11").method_27692(class_124.field_1061));
                return 0;
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Beacon Calculator ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Beacon Type: " + beaconType)).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("Beacon blocks needed: " + beaconBlocks)).method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total blocks for pyramid: " + totalBlocks)).method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"Materials needed:").method_27692(class_124.field_1060), false);
        if (beaconBlocks == 1) {
            source.method_9226(() -> class_2561.method_43470((String)"  - 1 Beacon").method_27692(class_124.field_1068), false);
            source.method_9226(() -> class_2561.method_43470((String)"  - 164 Iron/Gold/Diamond/Emerald/Netherite blocks").method_27692(class_124.field_1068), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"  - 6 Beacons").method_27692(class_124.field_1068), false);
            source.method_9226(() -> class_2561.method_43470((String)"  - 244 Iron/Gold/Diamond/Emerald/Netherite blocks").method_27692(class_124.field_1068), false);
        }
        return 1;
    }

    private static int executeCraftHelp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Crafting Recipes List ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"Use /calculator craft <item> <quantity> to calculate materials needed").method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Basic Blocks:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  chest, crafting_table, furnace, stick").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Tools:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Wooden: wooden_pickaxe, wooden_axe, wooden_shovel, wooden_hoe, wooden_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Stone: stone_pickaxe, stone_axe, stone_shovel, stone_hoe, stone_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Iron: iron_pickaxe, iron_axe, iron_shovel, iron_hoe, iron_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Gold: golden_pickaxe, golden_axe, golden_shovel, golden_hoe, golden_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Diamond: diamond_pickaxe, diamond_axe, diamond_shovel, diamond_hoe, diamond_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Netherite: netherite_pickaxe, netherite_axe, netherite_shovel, netherite_hoe, netherite_sword").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Armor:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Leather: leather_helmet, leather_chestplate, leather_leggings, leather_boots").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Iron: iron_helmet, iron_chestplate, iron_leggings, iron_boots").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Gold: golden_helmet, golden_chestplate, golden_leggings, golden_boots").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Diamond: diamond_helmet, diamond_chestplate, diamond_leggings, diamond_boots").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  Netherite: netherite_helmet, netherite_chestplate, netherite_leggings, netherite_boots").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Redstone:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  piston, sticky_piston, repeater, comparator, redstone_torch, lever").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  observer, hopper, dropper, dispenser").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Transportation:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  minecart, chest_minecart, furnace_minecart, hopper_minecart").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"  rail, powered_rail, detector_rail, activator_rail, oak_boat").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Decorative Blocks:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  glass, glass_pane, bookshelf, lantern, torch").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Food:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  bread, cake, cookie, golden_apple").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Storage:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  barrel, shulker_box").method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Miscellaneous:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"  beacon, ender_chest, bow, crossbow, shield, arrow").method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int executeBeaconArea(CommandContext<class_2168> context) throws CommandSyntaxException {
        String beaconType;
        int totalBlocksPerBeacon;
        int beaconBlocks;
        int beaconRange;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players in-game!").method_27692(class_124.field_1061));
            return 0;
        }
        int x1 = IntegerArgumentType.getInteger(context, (String)"x1");
        int y1 = IntegerArgumentType.getInteger(context, (String)"y1");
        int z1 = IntegerArgumentType.getInteger(context, (String)"z1");
        int x2 = IntegerArgumentType.getInteger(context, (String)"x2");
        int y2 = IntegerArgumentType.getInteger(context, (String)"y2");
        int z2 = IntegerArgumentType.getInteger(context, (String)"z2");
        String type = StringArgumentType.getString(context, (String)"type");
        int width = Math.abs(x2 - x1) + 1;
        int height = Math.abs(y2 - y1) + 1;
        int length = Math.abs(z2 - z1) + 1;
        switch (type.toLowerCase()) {
            case "1": 
            case "small": 
            case "9x9": {
                beaconRange = 50;
                beaconBlocks = 1;
                totalBlocksPerBeacon = 164;
                beaconType = "Small (9x9 base)";
                break;
            }
            case "2": 
            case "large": 
            case "10x11": {
                beaconRange = 50;
                beaconBlocks = 6;
                totalBlocksPerBeacon = 244;
                beaconType = "Large (10x11 base)";
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid beacon type! Use '1' or 'small' for 9x9, '2' or 'large' for 10x11").method_27692(class_124.field_1061));
                return 0;
            }
        }
        int beaconsX = (int)Math.ceil((double)width / (double)(beaconRange * 2));
        int beaconsZ = (int)Math.ceil((double)length / (double)(beaconRange * 2));
        int totalBeacons = beaconsX * beaconsZ;
        int totalBeaconBlocks = totalBeacons * beaconBlocks;
        int totalPyramidBlocks = totalBeacons * totalBlocksPerBeacon;
        source.method_9226(() -> class_2561.method_43470((String)"=== Beacon Area Calculator ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Area: " + width + "x" + height + "x" + length + " blocks")).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("Beacon Type: " + beaconType)).method_27692(class_124.field_1054), false);
        source.method_9226(() -> class_2561.method_43470((String)("Beacons needed: " + totalBeacons + " (" + beaconsX + "x" + beaconsZ + " grid)")).method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total beacon blocks: " + totalBeaconBlocks)).method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)("Total pyramid blocks: " + totalPyramidBlocks)).method_27692(class_124.field_1075), false);
        source.method_9226(() -> class_2561.method_43470((String)"Suggested beacon positions:").method_27692(class_124.field_1060), false);
        int minX = Math.min(x1, x2);
        int minZ = Math.min(z1, z2);
        int beaconY = Math.max(y1, y2);
        for (int bx = 0; bx < beaconsX; ++bx) {
            for (int bz = 0; bz < beaconsZ; ++bz) {
                int beaconX = minX + bx * beaconRange * 2 + beaconRange;
                int beaconZ = minZ + bz * beaconRange * 2 + beaconRange;
                int beaconIndex = bx * beaconsZ + bz + 1;
                source.method_9226(() -> class_2561.method_43470((String)("  Beacon " + beaconIndex + ": " + beaconX + ", " + beaconY + ", " + beaconZ)).method_27692(class_124.field_1068), false);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"Materials needed for activation:").method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)("  - " + totalBeaconBlocks + " Nether Stars")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("  - " + totalBeaconBlocks * 3 + " Glass blocks")).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)("  - " + totalBeaconBlocks * 3 + " Obsidian blocks")).method_27692(class_124.field_1068), false);
        return 1;
    }

    static {
        CalculatorCommand.initializeBasicRecipes();
        CalculatorCommand.initializeToolRecipes();
        CalculatorCommand.initializeArmorRecipes();
        CalculatorCommand.initializeRedstoneRecipes();
        CalculatorCommand.initializeTransportationRecipes();
        CalculatorCommand.initializeDecorativeRecipes();
        CalculatorCommand.initializeFoodRecipes();
        CalculatorCommand.initializeMiscRecipes();
    }
}

