/*
 * Decompiled with CFR 0.152.
 */
package groupix05.dtcroptopia.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import groupix05.dtcroptopia.blocks.IFallingFruit;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FallingPodBlock
extends PodBlock
implements IFallingFruit {
    DamageSource damageSource;
    public static float randomFruitFallChance = 0.005f;
    public static float playerDistanceToFall = 10.0f;

    public FallingPodBlock(BlockBehaviour.Properties properties, Pod pod) {
        super(properties, pod);
        this.damageSource = new DamageSource("dtcroptopia.falling_fruit." + pod.getRegistryName().m_135815_());
    }

    public boolean isSupported(LevelReader world, BlockPos pos, BlockState state) {
        BlockState branchState = world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
        return branch != null && branch.getRadius(branchState) == 3;
    }

    public void doTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (this.checkToFall(state, world, pos, random)) {
            this.doFall(state, world, pos);
        } else {
            super.doTick(state, world, pos, random);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((LevelReader)world, pos, state) && !this.doFall(state, world, pos)) {
            super.m_6861_(state, world, pos, block, fromPos, isMoving);
        }
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
    }

    @Override
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    @Override
    public int getRootY(BlockState state, Level world, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        for (int i = 0; i < 20; ++i) {
            BlockPos pos2 = pos.m_141952_(dir.m_122436_()).m_6625_(i);
            if (!(world.m_8055_(pos2).m_60734_() instanceof RootyBlock)) continue;
            return pos2.m_123342_();
        }
        return pos.m_123342_();
    }

    @Override
    public ItemStack getDropOnFallItems(ItemLike item, @Nonnull FallingBlockEntity entity) {
        if (entity.m_20194_() == null) {
            return ItemStack.f_41583_;
        }
        ServerLevel level = entity.m_20194_().m_129880_(entity.f_19853_.m_46472_());
        if (level == null) {
            return ItemStack.f_41583_;
        }
        List drops = FallingPodBlock.m_49869_((BlockState)entity.m_31980_(), (ServerLevel)level, (BlockPos)entity.m_142538_(), null);
        if (drops.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)drops.get(0);
    }

    @Override
    public float getRandomFruitFallChance() {
        return randomFruitFallChance;
    }

    @Override
    public float getPlayerDistanceToFall() {
        return playerDistanceToFall;
    }
}

