/*
 * Decompiled with CFR 0.152.
 */
package groupix05.dtcroptopia.blocks;

import com.google.common.collect.Lists;
import groupix05.dtcroptopia.init.DTCROPTOPIARegistries;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface IFallingFruit {
    public static final int fallDamageMax = 40;
    public static final float fallDamageAmount = 2.0f;

    public DamageSource getDamageSource();

    default public boolean checkToFall(BlockState state, Level world, BlockPos pos, Random random) {
        if (this.getAge(state) < this.getMaxAge()) {
            return false;
        }
        return random.nextFloat() <= this.getRandomFruitFallChance();
    }

    public int getRootY(BlockState var1, Level var2, BlockPos var3);

    default public boolean doFall(BlockState state, Level world, BlockPos pos) {
        if (this.getPlayerDistanceToFall() <= 0.0f) {
            return false;
        }
        int rootY = this.getRootY(state, world, pos);
        if (!world.m_45914_((double)pos.m_123341_(), (double)rootY, (double)pos.m_123343_(), (double)this.getPlayerDistanceToFall())) {
            return false;
        }
        if (pos.m_123342_() >= 0 && FallingBlock.m_53241_((BlockState)world.m_8055_(pos.m_7495_())) && world.m_46749_(pos) && !world.m_5776_()) {
            FallingBlockEntity fallingBlockEntity = this.getFallingEntity(world, pos, state);
            world.m_7967_((Entity)fallingBlockEntity);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    default public FallingBlockEntity getFallingEntity(Level world, final BlockPos pos, BlockState state) {
        return new FallingBlockEntity(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, state){

            public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
                int i = (int)Math.ceil(pFallDistance - 1.0f);
                if (i > 0) {
                    ArrayList list = Lists.newArrayList((Iterable)this.f_19853_.m_45933_((Entity)this, this.m_142469_()));
                    for (Entity entity : list) {
                        if (!(entity instanceof LivingEntity)) continue;
                        entity.m_6469_(IFallingFruit.this.getDamageSource(), (float)Math.min(Math.floor((float)i * 2.0f), 40.0) * pMultiplier);
                        this.f_19853_.m_5594_(null, pos, (SoundEvent)DTCROPTOPIARegistries.FRUIT_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                return false;
            }

            @Nullable
            public ItemEntity m_19998_(@Nonnull ItemLike pItem) {
                return null;
            }
        };
    }

    public ItemStack getDropOnFallItems(ItemLike var1, FallingBlockEntity var2);

    public float getRandomFruitFallChance();

    public float getPlayerDistanceToFall();

    public int getAge(BlockState var1);

    public int getMaxAge();
}

