/*
 * Decompiled with CFR 0.152.
 */
package groupix05.dtcroptopia.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;

public class PalmFruitGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Pod> POD = ConfigurationProperty.property((String)"pod", Pod.class);
    public static final ConfigurationProperty<Integer> EXPAND_UP_FRUIT_HEIGHT = ConfigurationProperty.integer((String)"expand_up_fruit_height");
    public static final ConfigurationProperty<Integer> EXPAND_DOWN_FRUIT_HEIGHT = ConfigurationProperty.integer((String)"expand_down_fruit_height");

    public PalmFruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{POD, QUANTITY, FRUITING_RADIUS, PLACE_CHANCE, EXPAND_UP_FRUIT_HEIGHT, EXPAND_DOWN_FRUIT_HEIGHT});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(POD, (Object)Pod.NULL)).with(QUANTITY, (Object)8)).with(FRUITING_RADIUS, (Object)6)).with(PLACE_CHANCE, (Object)Float.valueOf(0.25f))).with(EXPAND_UP_FRUIT_HEIGHT, (Object)0)).with(EXPAND_DOWN_FRUIT_HEIGHT, (Object)0);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        BlockPos rootPos;
        LevelAccessor world = context.level();
        if (TreeHelper.getRadius((BlockGetter)world, (BlockPos)(rootPos = context.pos()).m_7494_()) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural() && world.m_213780_().m_188502_() % 16 == 0 && context.species().seasonalFruitProductionFactor(LevelContext.create((LevelAccessor)world), rootPos) > world.m_213780_().m_188501_()) {
            this.addFruit(configuration, context.levelContext(), rootPos, this.getLeavesHeight(rootPos, world).m_7495_(), false);
            return true;
        }
        return false;
    }

    private BlockPos getLeavesHeight(BlockPos rootPos, LevelAccessor world) {
        for (int y = 1; y < 20; ++y) {
            BlockPos testPos = rootPos.m_6630_(y);
            if (!(world.m_8055_(testPos).m_60734_() instanceof LeavesBlock)) continue;
            return testPos;
        }
        return rootPos;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor world = context.level();
        BlockPos rootPos = context.pos();
        boolean placed = false;
        int qty = (Integer)configuration.get(QUANTITY);
        qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
        for (int i = 0; i < qty; ++i) {
            if (context.endPoints().isEmpty() || !(world.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
            this.addFruit(configuration, context.levelContext(), rootPos, (BlockPos)context.endPoints().get(0), true);
            placed = true;
        }
        return placed;
    }

    protected void addFruit(GenFeatureConfiguration configuration, LevelContext context, BlockPos rootPos, BlockPos leavesPos, boolean worldGen) {
        Direction placeDir;
        BlockPos pos;
        if (rootPos.m_123342_() == leavesPos.m_123342_()) {
            return;
        }
        LevelAccessor world = context.accessor();
        if (world.m_8055_(pos = this.expandRandom(configuration, world, leavesPos.m_121955_((placeDir = CoordUtils.HORIZONTALS[world.m_213780_().m_188503_(4)]).m_122436_()))).m_60767_().m_76336_()) {
            Float seasonValue = SeasonHelper.getSeasonValue((LevelContext)context, (BlockPos)rootPos);
            Pod pod = (Pod)configuration.get(POD);
            if (worldGen) {
                pod.placeDuringWorldGen(world, pos, seasonValue, placeDir.m_122424_(), 8);
            } else {
                pod.place(world, pos, seasonValue, placeDir.m_122424_(), 8);
            }
        }
    }

    protected BlockPos expandRandom(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos startingPos) {
        int fullHeight = 1 + (Integer)configuration.get(EXPAND_UP_FRUIT_HEIGHT) + (Integer)configuration.get(EXPAND_DOWN_FRUIT_HEIGHT);
        return startingPos.m_6625_(((Integer)configuration.get(EXPAND_DOWN_FRUIT_HEIGHT)).intValue()).m_6630_(world.m_213780_().m_188503_(fullHeight));
    }
}

