/*
 * Decompiled with CFR 0.152.
 */
package groupix05.dtcroptopia.genfeatures;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import groupix05.dtcroptopia.blocks.BananaSuckerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlantSuckerGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SUCKER_BLOCK = ConfigurationProperty.block((String)"sucker_block");
    public static final ConfigurationProperty<Float> PLACE_CHANCE_WORLDGEN = ConfigurationProperty.floatProperty((String)"place_chance_worldgen");

    public PlantSuckerGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{SUCKER_BLOCK, PLACE_CHANCE, PLACE_CHANCE_WORLDGEN});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)new GenFeatureConfiguration((GenFeature)this).with(SUCKER_BLOCK, (Object)Blocks.f_50016_)).with(PLACE_CHANCE, (Object)Float.valueOf(0.06f))).with(PLACE_CHANCE_WORLDGEN, (Object)Float.valueOf(0.6f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor world = context.level();
        boolean placed = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!(context.random().m_188501_() < ((Float)configuration.get(PLACE_CHANCE_WORLDGEN)).floatValue()) || !this.addSucker(world, context.pos(), true, (Block)configuration.get(SUCKER_BLOCK), dir)) continue;
            placed = true;
        }
        return placed;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.random().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            Direction dir = Direction.Plane.HORIZONTAL.m_235690_(context.random());
            return this.addSucker(context.level(), context.treePos(), false, (Block)configuration.get(SUCKER_BLOCK), dir);
        }
        return false;
    }

    private BlockPos getGroundPos(LevelAccessor world, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            BlockPos testPos = pos.m_7918_(0, i, 0);
            if (!world.isAreaLoaded(testPos, 16) || !world.m_8055_(testPos).m_60767_().m_76336_() || !world.m_8055_(testPos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP)) continue;
            return testPos;
        }
        return null;
    }

    private boolean addSucker(LevelAccessor world, BlockPos rootPos, boolean worldGen, Block sucker, Direction dir) {
        BlockPos ground = this.getGroundPos(world, rootPos.m_121955_(dir.m_122436_()));
        if (ground == null) {
            return false;
        }
        world.m_7731_(ground, (BlockState)sucker.m_49966_().m_61124_((Property)BananaSuckerBlock.f_54117_, (Comparable)dir), worldGen ? 0 : 2);
        return true;
    }
}

