/*
 * Decompiled with CFR 0.152.
 */
package groupix05.dtcroptopia.models.baked_models;

import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;

public class MediumPalmLeavesBakedModel
implements IDynamicBakedModel {
    public static List<MediumPalmLeavesBakedModel> INSTANCES = new ArrayList<MediumPalmLeavesBakedModel>();
    protected final BlockModel blockModel;
    ResourceLocation frondsResLoc;
    TextureAtlasSprite frondsTexture;
    private final BakedModel[] bakedFronds = new BakedModel[8];

    public MediumPalmLeavesBakedModel(ResourceLocation modelResLoc, ResourceLocation frondsResLoc) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.frondsResLoc = frondsResLoc;
        INSTANCES.add(this);
    }

    public void setupModels() {
        this.frondsTexture = ModelUtils.getTexture((ResourceLocation)this.frondsResLoc);
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(this.frondsTexture);
            BlockVertexData[] quadData = new BlockVertexData[]{new BlockVertexData(0.0f, 0.0f, 3.0f, 15.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 3.0f, 15.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 3.0f, 15.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 3.0f, 15.0f, 0.0f)};
            for (int pass = 0; pass < 3; ++pass) {
                for (int half = 0; half < 2; ++half) {
                    if (pass == 0 && surr.ordinal() % 2 != 0 || pass == 2 && surr.ordinal() % 2 == 0) continue;
                    BlockVertexData[] outData = new BlockVertexData[8];
                    for (int v = 0; v < 8; ++v) {
                        float x = quadData[v].x;
                        float z = quadData[v].z;
                        float y = quadData[v].y;
                        double len = 0.75 - (double)y;
                        double angle = Math.atan2(x *= 1.25f, y);
                        x = (float)(Math.sin(angle += Math.PI * (half == 1 ? 1.2 : -1.2)) * len);
                        y = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(y * y + (z *= 1.25f) * z);
                        angle = Math.atan2(y, z);
                        y = (float)(Math.sin(angle += Math.PI * (pass == 2 ? 0.28 : (pass == 1 ? 0.06 : -0.17))) * len);
                        z = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(x * x + z * z);
                        angle = Math.atan2(x, z);
                        x = (float)(Math.sin(angle += 0.7853981633974483 * (double)surr.ordinal() + Math.PI * (pass == 1 ? -0.065 : (pass == 2 ? 0.08 : 0.005))) * len);
                        z = (float)(Math.cos(angle) * len);
                        x += 0.5f;
                        z += 0.5f;
                        y = (float)((double)y + (pass == 2 ? -0.125 : (pass == 0 ? 0.125 : 0.0)));
                        outData[v] = new BlockVertexData(x += (float)surr.getOffset().m_123341_(), y, z += (float)surr.getOffset().m_123343_(), quadData[v].u, quadData[v].v);
                    }
                    int[] vertices = Ints.concat((int[][])new int[][]{outData[0].toInts(this.frondsTexture), outData[1].toInts(this.frondsTexture), outData[2].toInts(this.frondsTexture), outData[3].toInts(this.frondsTexture)});
                    builder.m_119526_(new BakedQuad(vertices, 0, FaceBakery.m_111612_((int[])vertices), this.frondsTexture, true));
                    vertices = Ints.concat((int[][])new int[][]{outData[4].toInts(this.frondsTexture), outData[5].toInts(this.frondsTexture), outData[6].toInts(this.frondsTexture), outData[7].toInts(this.frondsTexture)});
                    builder.m_119526_(new BakedQuad(vertices, 0, FaceBakery.m_111612_((int[])vertices), this.frondsTexture, true));
                    this.bakedFronds[surr.ordinal()] = builder.m_119533_();
                }
            }
        }
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        int direction = (Integer)state.m_61143_((Property)PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION);
        if (direction != 0) {
            quads.addAll(this.bakedFronds[direction - 1].getQuads(state, null, rand, extraData, renderType));
        }
        return quads;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.frondsTexture;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public static class BlockVertexData {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;

        public BlockVertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = -1;
        }

        public BlockVertexData(BakedQuad quad, int vIndex) {
            this(quad.m_111303_(), vIndex);
        }

        public BlockVertexData(int[] data, int vIndex) {
            vIndex *= 8;
            this.x = Float.intBitsToFloat(data[vIndex++]);
            this.y = Float.intBitsToFloat(data[vIndex++]);
            this.z = Float.intBitsToFloat(data[vIndex++]);
            this.color = data[vIndex++];
            this.u = Float.intBitsToFloat(data[vIndex++]);
            this.v = Float.intBitsToFloat(data[vIndex]);
        }

        public int[] toInts() {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(this.u), Float.floatToRawIntBits(this.v), 0, 0};
        }

        protected int[] toInts(TextureAtlasSprite texture) {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(texture.m_118367_((double)this.u)), Float.floatToRawIntBits(texture.m_118393_((double)this.v)), 0, 0};
        }
    }
}

