/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.storage;

import java.util.HashMap;

public class TileFlags {
    public final HashMap<Long, long[]> chunkmap = new HashMap();
    private long last_key = Long.MAX_VALUE;
    private long[] last_row;

    public boolean getFlag(int x, int y) {
        long[] row;
        long k = (long)(x >> 6) << 32 | 0xFFFFFFFFL & (long)(y >> 6);
        if (k == this.last_key) {
            row = this.last_row;
        } else {
            row = this.chunkmap.get(k);
            this.last_key = k;
            this.last_row = row;
        }
        if (row == null) {
            return false;
        }
        return (row[y & 0x3F] & 1L << (x & 0x3F)) != 0L;
    }

    public void setFlag(int x, int y, boolean f) {
        long[] row;
        long k = (long)(x >> 6) << 32 | 0xFFFFFFFFL & (long)(y >> 6);
        if (k == this.last_key) {
            row = this.last_row;
        } else {
            row = this.chunkmap.get(k);
            this.last_key = k;
            this.last_row = row;
        }
        if (f) {
            if (row == null) {
                row = new long[64];
                this.chunkmap.put(k, row);
                this.last_row = row;
            }
            int n = y & 0x3F;
            row[n] = row[n] | 1L << (x & 0x3F);
        } else if (row != null) {
            int n = y & 0x3F;
            row[n] = row[n] & (1L << (x & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void clear() {
        this.chunkmap.clear();
        this.last_row = null;
        this.last_key = Long.MAX_VALUE;
    }
}

