/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.update;

import org.bukkit.plugin.Plugin;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.leralix.tancommon.geometry.ChunkManager;
import org.leralix.tancommon.storage.RegionDescription;
import org.leralix.tancommon.storage.RegionDescriptionStorage;
import org.leralix.tancommon.storage.TownDescription;
import org.leralix.tancommon.storage.TownDescriptionStorage;
import org.tan.api.TanAPI;
import org.tan.api.interfaces.TanRegion;
import org.tan.api.interfaces.TanTown;

public class UpdateChunks
implements Runnable {
    private final ChunkManager chunkManager;
    private final Long updatePeriod;

    public UpdateChunks(ChunkManager chunkManager, long updatePeriod) {
        this.chunkManager = chunkManager;
        this.updatePeriod = updatePeriod;
    }

    public UpdateChunks(UpdateChunks copy) {
        this.chunkManager = copy.chunkManager;
        this.updatePeriod = copy.updatePeriod;
    }

    @Override
    public void run() {
        this.update();
    }

    public void update() {
        TanAPI tanAPI = TanAPI.getInstance();
        for (TanTown townData : tanAPI.getTerritoryManager().getTowns()) {
            TownDescription townDescription = new TownDescription(townData);
            TownDescriptionStorage.add(townDescription);
            this.chunkManager.update(townData);
        }
        for (TanRegion regionData : tanAPI.getTerritoryManager().getRegions()) {
            RegionDescription regionDescription = new RegionDescription(regionData);
            RegionDescriptionStorage.add(regionDescription);
            this.chunkManager.update(regionData);
        }
        TownsAndNationsMapCommon plugin = TownsAndNationsMapCommon.getPlugin();
        if (this.updatePeriod > 0L) {
            plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new UpdateChunks(this), this.updatePeriod.longValue());
        }
    }
}

