/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon;

import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.data.PluginVersion;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tancommon.bstat.Metrics;
import org.leralix.tancommon.commands.PlayerCommandManager;
import org.leralix.tancommon.geometry.ChunkManager;
import org.leralix.tancommon.geometry.PolygonBuilder;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.storage.Constants;
import org.leralix.tancommon.update.UpdateChunks;
import org.leralix.tancommon.update.UpdateForts;
import org.leralix.tancommon.update.UpdateLandMarks;
import org.leralix.tancommon.update.UpdateProperty;
import org.tan.api.TanAPI;

public abstract class TownsAndNationsMapCommon
extends JavaPlugin {
    private static TownsAndNationsMapCommon plugin;
    private final Logger logger = this.getLogger();
    private CommonMarkerRegister markerRegister;
    private long updatePeriod;
    private final PluginVersion pluginVersion = new PluginVersion(Integer.valueOf(0), Integer.valueOf(15), Integer.valueOf(0));
    private UpdateLandMarks updateLandMarks;
    private UpdateChunks updateChunks;
    private UpdateForts updateForts;
    private UpdateProperty updateProperty;
    private final String subMapName = "[TaN - " + this.getSubMapName() + "] - ";

    public void onEnable() {
        this.saveDefaultConfig();
        plugin = this;
        this.logger.info(this.subMapName + "Loading Plugin");
        new Metrics(this, this.getBStatID());
        PluginManager pm = this.getServer().getPluginManager();
        Plugin tanPlugin = pm.getPlugin("TownsAndNations");
        if (tanPlugin == null || !tanPlugin.isEnabled()) {
            this.logger.severe(this.subMapName + "Cannot find Towns and Nations, check your logs to see if it enabled properly?!");
            this.setEnabled(false);
            return;
        }
        TanAPI api = TanAPI.getInstance();
        PluginVersion minTanVersion = api.getMinimumSupportingMapPlugin();
        if (this.pluginVersion.isOlderThan(minTanVersion)) {
            this.logger.log(Level.SEVERE, this.subMapName + "Towns and Nations is not compatible with this version of tanmap (minimum version: {0})", minTanVersion);
            this.setEnabled(false);
            return;
        }
        Objects.requireNonNull(this.getCommand("tanmap")).setExecutor((CommandExecutor)new PlayerCommandManager());
        ConfigUtil.saveAndUpdateResource((Plugin)this, (String)"config.yml");
        ConfigUtil.addCustomConfig((Plugin)this, (String)"config.yml", (ConfigTag)ConfigTag.MAIN);
        Constants.init();
        this.initialise();
        this.logger.info(this.subMapName + "Plugin is running");
    }

    private void initialise() {
        this.markerRegister = this.createMarkerRegister();
        this.registerIcons(this.markerRegister);
        if (!this.markerRegister.isWorking()) {
            this.logger.severe(this.subMapName + "Cannot find marker API, retrying in 5 seconds");
            new BukkitRunnable(){

                public void run() {
                    TownsAndNationsMapCommon.this.initialise();
                }
            }.runTaskLater((Plugin)this, 100L);
            return;
        }
        this.logger.info(this.subMapName + "Marker API found");
        int period = Constants.getUpdatePeriod();
        if (period < 15) {
            period = 15;
        }
        this.updatePeriod = (long)period * 20L;
        this.markerRegister.setup();
        this.startTasks();
    }

    private void registerIcons(CommonMarkerRegister markerRegister) {
        File iconsDir = new File(this.getDataFolder(), "icons");
        if (!iconsDir.exists()) {
            iconsDir.mkdirs();
        }
        for (IconType iconType : IconType.values()) {
            File iconFile = new File(iconsDir, iconType.getFileName());
            if (!iconFile.exists()) {
                TownsAndNationsMapCommon.getPlugin().saveResource("icons/" + iconType.getFileName(), true);
            }
            markerRegister.registerIcon(iconType);
        }
    }

    private void startTasks() {
        PolygonBuilder polygonBuilder = new PolygonBuilder(Constants.getMaxIteration());
        this.updateChunks = new UpdateChunks(new ChunkManager(this.markerRegister, polygonBuilder), this.updatePeriod);
        this.updateLandMarks = new UpdateLandMarks(this.markerRegister, this.updatePeriod);
        this.updateForts = new UpdateForts(this.markerRegister, this.updatePeriod);
        this.updateProperty = new UpdateProperty(this.markerRegister, this.updatePeriod);
        Runnable deleteAllRunnable = () -> this.markerRegister.deleteAllMarkers();
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, deleteAllRunnable, 40L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)this.updateChunks, 40L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)this.updateLandMarks, 40L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.updateForts, 40L, this.updatePeriod);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)this.updateProperty, 40L);
    }

    public static TownsAndNationsMapCommon getPlugin() {
        return plugin;
    }

    public void updateDynmap() {
        this.markerRegister.deleteAllMarkers();
        this.updateChunks.update();
        this.updateLandMarks.update();
        this.updateForts.update();
        this.updateProperty.update();
    }

    protected abstract String getSubMapName();

    protected abstract int getBStatID();

    protected abstract CommonMarkerRegister createMarkerRegister();
}

