/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.geometry;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.leralix.tancommon.geometry.PolygonBuilder;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tancommon.storage.RegionDescriptionStorage;
import org.leralix.tancommon.storage.TileFlags;
import org.leralix.tancommon.storage.TownDescriptionStorage;
import org.tan.api.interfaces.TanClaimedChunk;
import org.tan.api.interfaces.TanRegion;
import org.tan.api.interfaces.TanTerritory;
import org.tan.api.interfaces.TanTown;

public class ChunkManager {
    private final PolygonBuilder polygonBuilder;
    private final CommonMarkerRegister commonMarkerRegister;

    public ChunkManager(CommonMarkerRegister markerRegister, PolygonBuilder polygonBuilder) {
        this.commonMarkerRegister = markerRegister;
        this.polygonBuilder = polygonBuilder;
    }

    public void update(TanTown town) {
        String infoWindowPopup = TownDescriptionStorage.get(town.getID()).getChunkDescription();
        this.updateTerritory((TanTerritory)town, infoWindowPopup);
    }

    public void update(TanRegion region) {
        String infoWindowPopup = RegionDescriptionStorage.get(region.getID()).getChunkDescription();
        this.updateTerritory((TanTerritory)region, infoWindowPopup);
    }

    private void updateTerritory(TanTerritory territory, String infoWindowPopup) {
        int polyIndex = 0;
        Collection townClaimedChunks = territory.getClaimedChunks();
        if (townClaimedChunks.isEmpty()) {
            return;
        }
        HashMap<String, TileFlags> worldNameShapeMap = new HashMap<String, TileFlags>();
        LinkedList<TanClaimedChunk> claimedChunksToDraw = new LinkedList<TanClaimedChunk>();
        World currentWorld = null;
        TileFlags currentShape = null;
        for (TanClaimedChunk townClaimedChunk : townClaimedChunks) {
            World world = Bukkit.getWorld((UUID)townClaimedChunk.getWorldUUID());
            if (world == null) continue;
            if (world != currentWorld) {
                String worldName = world.getName();
                currentShape = (TileFlags)worldNameShapeMap.get(worldName);
                if (currentShape == null) {
                    currentShape = new TileFlags();
                    worldNameShapeMap.put(worldName, currentShape);
                }
                currentWorld = world;
            }
            if (currentShape == null) {
                currentShape = new TileFlags();
            }
            currentShape.setFlag(townClaimedChunk.getX(), townClaimedChunk.getZ(), true);
            claimedChunksToDraw.addLast(townClaimedChunk);
        }
        while (claimedChunksToDraw != null) {
            LinkedList<TanClaimedChunk> ourTownBlocks = null;
            LinkedList<TanClaimedChunk> townBlockLeftToDraw = null;
            TileFlags ourShape = null;
            int minx = Integer.MAX_VALUE;
            int minz = Integer.MAX_VALUE;
            for (TanClaimedChunk claimedChunk : claimedChunksToDraw) {
                int tbX = claimedChunk.getX();
                int tbZ = claimedChunk.getZ();
                World world = Bukkit.getWorld((UUID)claimedChunk.getWorldUUID());
                if (ourShape == null && world != currentWorld) {
                    currentWorld = world;
                    currentShape = (TileFlags)worldNameShapeMap.get(currentWorld.getName());
                }
                if (ourShape == null && currentShape.getFlag(tbX, tbZ)) {
                    ourShape = new TileFlags();
                    ourTownBlocks = new LinkedList<TanClaimedChunk>();
                    this.floodFillTarget(currentShape, ourShape, tbX, tbZ);
                    ourTownBlocks.add(claimedChunk);
                    minx = tbX;
                    minz = tbZ;
                    continue;
                }
                if (ourShape != null && world == currentWorld && ourShape.getFlag(tbX, tbZ)) {
                    ourTownBlocks.add(claimedChunk);
                    if (tbX < minx) {
                        minx = tbX;
                        minz = tbZ;
                        continue;
                    }
                    if (tbX != minx || tbZ >= minz) continue;
                    minz = tbZ;
                    continue;
                }
                if (townBlockLeftToDraw == null) {
                    townBlockLeftToDraw = new LinkedList<TanClaimedChunk>();
                }
                townBlockLeftToDraw.add(claimedChunk);
            }
            claimedChunksToDraw = townBlockLeftToDraw;
            if (ourShape == null) continue;
            polyIndex = this.traceTerritoryOutline(territory, polyIndex, infoWindowPopup, currentWorld.getName(), ourShape, minx, minz);
        }
    }

    private void floodFillTarget(TileFlags src, TileFlags dest, int x, int y) {
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{x, y});
        while (!stack.isEmpty()) {
            int[] nxt = (int[])stack.pop();
            x = nxt[0];
            if (!src.getFlag(x, y = nxt[1])) continue;
            src.setFlag(x, y, false);
            dest.setFlag(x, y, true);
            if (src.getFlag(x + 1, y)) {
                stack.push(new int[]{x + 1, y});
            }
            if (src.getFlag(x - 1, y)) {
                stack.push(new int[]{x - 1, y});
            }
            if (src.getFlag(x, y + 1)) {
                stack.push(new int[]{x, y + 1});
            }
            if (!src.getFlag(x, y - 1)) continue;
            stack.push(new int[]{x, y - 1});
        }
    }

    private int traceTerritoryOutline(TanTerritory territoryData, int polyIndex, String infoWindowPopup, String worldName, TileFlags ourShape, int minx, int minz) {
        String polyid = territoryData.getID() + "_" + polyIndex;
        PolygonCoordinate polygonCoordinate = this.polygonBuilder.buildPolygon(ourShape, minx, minz);
        Collection<PolygonCoordinate> holes = this.polygonBuilder.getHoles(ourShape, polygonCoordinate);
        this.commonMarkerRegister.registerNewArea(polyid, territoryData, false, worldName, polygonCoordinate, infoWindowPopup, holes);
        return ++polyIndex;
    }

    static enum direction {
        XPLUS,
        ZPLUS,
        XMINUS,
        ZMINUS;

    }
}

