/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.markers;

import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.position.Vector2D;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.markers.LayerConfig;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.tan.api.interfaces.TanFort;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanProperty;
import org.tan.api.interfaces.TanTerritory;

public abstract class CommonMarkerRegister {
    public void setup() {
        FileConfiguration cfg = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN);
        LayerConfig chunkLayerConfig = this.extractLayerData(cfg, "chunk_layer", "Territories");
        this.setupChunkLayer(chunkLayerConfig.getId(), chunkLayerConfig.getName(), chunkLayerConfig.getMinZoom(), chunkLayerConfig.getPriority(), chunkLayerConfig.isHideByDefault(), chunkLayerConfig.getWorldsName());
        LayerConfig landmarkLayerConfig = this.extractLayerData(cfg, "landmark_layer", "Landmarks");
        this.setupLandmarkLayer(landmarkLayerConfig.getId(), landmarkLayerConfig.getName(), landmarkLayerConfig.getMinZoom(), landmarkLayerConfig.getPriority(), landmarkLayerConfig.isHideByDefault(), landmarkLayerConfig.getWorldsName());
        LayerConfig fortLayerConfig = this.extractLayerData(cfg, "fort_layer", "Forts");
        this.setupFortLayer(fortLayerConfig.getId(), fortLayerConfig.getName(), fortLayerConfig.getMinZoom(), fortLayerConfig.getPriority(), fortLayerConfig.isHideByDefault(), fortLayerConfig.getWorldsName());
        LayerConfig propertyLayerConfig = this.extractLayerData(cfg, "property_layer", "Properties");
        this.setupPropertyLayer(propertyLayerConfig.getId(), propertyLayerConfig.getName(), propertyLayerConfig.getMinZoom(), propertyLayerConfig.getPriority(), propertyLayerConfig.isHideByDefault(), propertyLayerConfig.getWorldsName());
    }

    private LayerConfig extractLayerData(FileConfiguration cfg, String configSectionName, String layerName) {
        String id = "townsandnations." + layerName.toLowerCase();
        String name = cfg.getString(configSectionName + ".name", "Towns and Nations - " + layerName);
        int minZoom = Math.max(cfg.getInt(configSectionName + ".minimum_zoom", 0), 0);
        int chunkLayerPriority = Math.max(cfg.getInt(configSectionName + ".priority", 10), 0);
        boolean hideByDefault = cfg.getBoolean(configSectionName + ".hide_by_default", false);
        List worldsName = cfg.getStringList(configSectionName + ".worlds");
        return new LayerConfig(id, name, minZoom, chunkLayerPriority, hideByDefault, worldsName);
    }

    protected abstract void setupLandmarkLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    protected abstract void setupChunkLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    protected abstract void setupFortLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    protected abstract void setupPropertyLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    public abstract boolean isWorking();

    public abstract void registerNewLandmark(TanLandmark var1);

    public abstract void registerNewFort(TanFort var1);

    public abstract void registerNewProperty(TanProperty var1);

    public abstract void registerNewArea(String var1, TanTerritory var2, boolean var3, String var4, PolygonCoordinate var5, String var6, Collection<PolygonCoordinate> var7);

    protected String generateDescription(TanLandmark landmark) {
        String res = TownsAndNationsMapCommon.getPlugin().getConfig().getString("landmark_infowindow");
        if (res == null) {
            return "No description";
        }
        ItemStack reward = landmark.getItem();
        String ownerName = landmark.isOwned() ? landmark.getOwner().getName() : "No owner";
        res = res.replace("%LANDMARK_NAME%", landmark.getName());
        res = res.replace("%QUANTITY%", String.valueOf(reward.getAmount()));
        res = res.replace("%ITEM%", reward.getType().name());
        res = res.replace("%OWNER%", ownerName);
        return res;
    }

    protected String generateDescription(TanProperty property) {
        String res = TownsAndNationsMapCommon.getPlugin().getConfig().getString("property_infowindow");
        if (res == null) {
            return "No description";
        }
        Object status = property.isForSale() ? "For Sale (" + property.getSalePrice() + ")" : (property.isRented() ? "Rented by " + ((TanPlayer)property.getRenter().get()).getNameStored() : (property.isForRent() ? "For Rent (" + property.getRentPrice() + ")" : "Not for sale or rent"));
        res = res.replace("%PROPERTY_NAME%", property.getName());
        res = res.replace("%PROPERTY_DESCRIPTION%", property.getDescription());
        res = res.replace("%PROPERTY_OWNER%", property.getOwner().getName());
        res = res.replace("%STATUS%", (CharSequence)status);
        return res;
    }

    protected String generateDescription(TanFort fort) {
        String res = TownsAndNationsMapCommon.getPlugin().getConfig().getString("fort_infowindow");
        if (res == null) {
            return "No description";
        }
        res = res.replace("%FORT_NAME%", fort.getName());
        res = res.replace("%OWNER%", fort.getOwner().getName());
        res = res.replace("%OCCUPIER%", fort.getOccupier() != null ? fort.getOccupier().getName() : "No occupier");
        return res;
    }

    public abstract void deleteAllMarkers();

    public abstract void registerIcon(IconType var1);

    public abstract void registerCapital(String var1, Vector2D var2);

    protected static PolygonCoordinate getPolygonCoordinate(Vector3D point1, Vector3D point2) {
        int[] x = new int[]{point1.getX(), point2.getX(), point2.getX(), point1.getX()};
        int[] z = new int[]{point1.getZ(), point1.getZ(), point2.getZ(), point2.getZ()};
        return new PolygonCoordinate(x, z);
    }
}

