/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.storage;

import org.bukkit.configuration.file.FileConfiguration;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.tan.api.interfaces.TanProperty;

public class Constants {
    private static int updatePeriod;
    private static int maxIteration;
    private static int propertyOwnedColor;
    private static int propertyForSaleColor;
    private static int propertyRentedColor;
    private static int propertyForRentColor;

    public static void init() {
        FileConfiguration fileConfiguration = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN);
        updatePeriod = fileConfiguration.getInt("update.period", 300);
        maxIteration = fileConfiguration.getInt("polygon_max_points", 100000);
        propertyOwnedColor = Constants.convertToInt(fileConfiguration.getString("propertiesColor.owned", "#FFA500"));
        propertyForSaleColor = Constants.convertToInt(fileConfiguration.getString("propertiesColor.for_rent", "#89CFF0"));
        propertyRentedColor = Constants.convertToInt(fileConfiguration.getString("propertiesColor.rented", "#ff0000"));
        propertyForRentColor = Constants.convertToInt(fileConfiguration.getString("propertiesColor.for_sale", "#008000"));
    }

    private static int convertToInt(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        return Integer.parseInt(hex, 16);
    }

    public static int getUpdatePeriod() {
        return updatePeriod;
    }

    public static int getMaxIteration() {
        return maxIteration;
    }

    public static int getPropertyColor(TanProperty tanProperty) {
        if (tanProperty.isForSale()) {
            return propertyForSaleColor;
        }
        if (tanProperty.isForRent()) {
            return propertyForRentColor;
        }
        if (tanProperty.isRented()) {
            return propertyRentedColor;
        }
        return propertyOwnedColor;
    }
}

