/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanTown;

public class TownDescription {
    private final String id;
    private final String name;
    private final int daysSinceCreation;
    private final String description;
    private final int numberOfClaims;
    private final int townLevel;
    private final int numberOfMembers;
    private final String ownerName;
    private final String regionName;
    private final String nationName;
    private final List<String> membersName;

    public TownDescription(TanTown town) {
        Collection players = town.getMembers();
        Date today = new Date();
        Date creationDate = new Date(town.getCreationDate());
        long diffInDays = today.getTime() - creationDate.getTime();
        int nbDays = (int)(diffInDays / 86400000L);
        int numberOfChunks = town.getNumberOfClaimedChunk();
        int townLevel = town.getLevel();
        int nbPlayer = players.size();
        String description = town.getDescription();
        TanPlayer owner = town.getOwner();
        this.ownerName = owner == null ? "" : owner.getNameStored();
        String regionName = "No region";
        if (town.haveOverlord()) {
            regionName = town.getOverlord().getName();
        }
        ArrayList<String> playersName = new ArrayList<String>();
        for (TanPlayer player : players) {
            playersName.add(player.getNameStored());
        }
        this.id = town.getID();
        this.name = town.getName();
        this.daysSinceCreation = nbDays;
        this.description = description;
        this.numberOfClaims = numberOfChunks;
        this.townLevel = townLevel;
        this.numberOfMembers = nbPlayer;
        this.regionName = regionName;
        this.nationName = this.name;
        this.membersName = playersName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getNationName() {
        return this.nationName;
    }

    public List<String> getMembersName() {
        return this.membersName;
    }

    public String getChunkDescription() {
        String message = TownsAndNationsMapCommon.getPlugin().getConfig().getString("town_infowindow", "Config not found - town");
        message = message.replace("%TOWN_NAME%", this.name);
        message = message.replace("%DAYS_SINCE_CREATION%", String.valueOf(this.daysSinceCreation));
        message = message.replace("%DESCRIPTION%", this.description);
        message = message.replace("%NUMBER_CLAIMS%", String.valueOf(this.numberOfClaims));
        message = message.replace("%TOWN_LEVEL%", String.valueOf(this.townLevel));
        message = message.replace("%REGION_NAME%", Objects.requireNonNullElse(this.regionName, "No region"));
        message = message.replace("%TOWN_LEADER%", this.ownerName);
        message = message.replace("%MEMBERS_LIST%", this.getMemberList());
        return message;
    }

    private String getMemberList() {
        StringBuilder memberList = new StringBuilder();
        for (String member : this.getMembersName()) {
            memberList.append(member).append(", ");
        }
        return memberList.toString();
    }
}

