/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.minecraft.class_5699;
import net.minecraft.class_8957;

public final class ShapedRecipePatternCodecs {
    private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
        String line;
        if (pattern.isEmpty()) {
            return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
        }
        int length = ((String)pattern.getFirst()).length();
        Iterator lines = pattern.iterator();
        do {
            if (lines.hasNext()) continue;
            return DataResult.success((Object)pattern);
        } while (length == (line = (String)lines.next()).length());
        return DataResult.error(() -> "Invalid pattern: each row must be the same width");
    }, Function.identity());
    public static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(symbol -> {
        if (symbol.length() != 1) {
            return DataResult.error(() -> "Invalid key entry: '" + symbol + "' is an invalid symbol (must be 1 character only).");
        }
        return " ".equals(symbol) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(symbol.charAt(0)));
    }, String::valueOf);
    private static final MapCodec<class_8957.class_8958> DATA_MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_5699.method_53703(SYMBOL_CODEC, (Codec)class_1856.field_46096).fieldOf("key").forGetter(class_8957.class_8958::comp_2085), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(class_8957.class_8958::comp_2086)).apply((Applicative)builder, class_8957.class_8958::new));
    public static final MapCodec<class_8957> MAP_CODEC = DATA_MAP_CODEC.flatXmap(class_8957::method_55080, pattern -> pattern.field_51640.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
}

