/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.compat.almostunified.AlmostUnifiedAdapter;
import com.blakebr0.cucumber.config.ModConfigs;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.fabricators_of_create.porting_lib.resources.events.TagsUpdatedEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.IOUtils;

public class TagMapper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, String> TAG_TO_ITEM_MAP = new HashMap<String, String>();

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData()) {
            TagMapper.reloadTagMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadTagMappings() {
        Stopwatch stopwatch;
        block5: {
            File file;
            block6: {
                stopwatch = Stopwatch.createStarted();
                File dir = FabricLoader.getInstance().getConfigDir().toFile();
                TAG_TO_ITEM_MAP.clear();
                if (!dir.exists() || !dir.isDirectory()) break block5;
                file = FabricLoader.getInstance().getConfigDir().resolve("cucumber-tags.json").toFile();
                if (!file.exists() || !file.isFile()) break block6;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    json.entrySet().stream().filter(e -> {
                        String value = ((JsonElement)e.getValue()).getAsString();
                        return !"__comment".equalsIgnoreCase((String)e.getKey()) && !value.isEmpty() && !"null".equalsIgnoreCase(value);
                    }).forEach(entry -> {
                        class_1792 item;
                        String tagId = (String)entry.getKey();
                        String itemId = ((JsonElement)entry.getValue()).getAsString();
                        TAG_TO_ITEM_MAP.put(tagId, itemId);
                        if (!(!((Boolean)ModConfigs.AUTO_REFRESH_TAG_ENTRIES.get()).booleanValue() || itemId.isEmpty() || "null".equalsIgnoreCase(itemId) || (item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId))) != null && item != class_1802.field_8162)) {
                            TagMapper.addTagToFile(tagId, json, file, false);
                        }
                    });
                    if (((Boolean)ModConfigs.AUTO_REFRESH_TAG_ENTRIES.get()).booleanValue()) {
                        TagMapper.saveToFile(json, file);
                    }
                    reader.close();
                }
                catch (Exception e2) {
                    try {
                        Cucumber.LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block5;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block5;
            }
            TagMapper.generateNewConfig(file);
        }
        stopwatch.stop();
        Cucumber.LOGGER.info("Loaded cucumber-tags.json in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1792 getItemForTag(String tagId) {
        block10: {
            class_1792 preferredItem = AlmostUnifiedAdapter.getPreferredItemForTag(tagId);
            if (preferredItem != null) {
                return preferredItem;
            }
            if (TAG_TO_ITEM_MAP.containsKey(tagId)) {
                String id = TAG_TO_ITEM_MAP.get(tagId);
                return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id));
            }
            File file = FabricLoader.getInstance().getConfigDir().resolve("cucumber-tags.json").toFile();
            if (!file.exists()) {
                TagMapper.generateNewConfig(file);
            }
            if (!file.isFile()) break block10;
            JsonObject json = null;
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                try {
                    Cucumber.LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (json != null) {
                if (json.has(tagId)) {
                    String itemId = json.get(tagId).getAsString();
                    if (itemId.isEmpty() || "null".equalsIgnoreCase(itemId)) {
                        return TagMapper.addTagToFile(tagId, json, file);
                    }
                    TAG_TO_ITEM_MAP.put(tagId, itemId);
                    return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId));
                }
                return TagMapper.addTagToFile(tagId, json, file);
            }
        }
        return class_1802.field_8162;
    }

    public static class_1799 getItemStackForTag(String tagId, int size) {
        class_1792 item = TagMapper.getItemForTag(tagId);
        return item != null && item != class_1802.field_8162 ? new class_1799((class_1935)item, size) : class_1799.field_8037;
    }

    private static class_1792 addTagToFile(String tagId, JsonObject json, File file) {
        return TagMapper.addTagToFile(tagId, json, file, true);
    }

    private static class_1792 addTagToFile(String tagId, JsonObject json, File file, boolean save) {
        List mods = (List)ModConfigs.MOD_TAG_PRIORITIES.get();
        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)tagId));
        class_1792 item = class_7923.field_41178.method_40266(key).stream().filter(t -> t.method_40247() > 0).min((item1, item2) -> {
            class_2960 id2;
            int index2;
            class_2960 id1 = class_7923.field_41178.method_10221((Object)((class_1792)item1.method_40240(0).comp_349()));
            int index1 = mods.indexOf(id1.method_12836());
            return index1 > (index2 = mods.indexOf((id2 = class_7923.field_41178.method_10221((Object)((class_1792)item2.method_40240(0).comp_349()))).method_12836())) ? 1 : (index1 == -1 ? 0 : -1);
        }).map(v -> (class_1792)v.method_40240(0).comp_349()).orElse(class_1802.field_8162);
        String itemId = "null";
        if (item != class_1802.field_8162) {
            itemId = class_7923.field_41178.method_10221((Object)item).toString();
        }
        json.addProperty(tagId, itemId);
        TAG_TO_ITEM_MAP.put(tagId, itemId);
        if (save) {
            TagMapper.saveToFile(json, file);
        }
        return item;
    }

    private static void saveToFile(JsonObject json, File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            Cucumber.LOGGER.error("An error occurred while writing to cucumber-tags.json", (Throwable)e);
        }
    }

    private static void generateNewConfig(File file) {
        try (FileWriter writer = new FileWriter(file);){
            JsonObject object = new JsonObject();
            object.addProperty("__comment", "Instructions: https://blakesmods.com/docs/cucumber/tags-config");
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            Cucumber.LOGGER.error("An error occurred while creating cucumber-tags.json", (Throwable)e);
        }
    }
}

