/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.energy;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class BaseEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public long amount = 0L;
    public long capacity;
    public final long maxInsert;
    public final long maxExtract;
    private final Runnable onContentsChanged;

    public BaseEnergyStorage(long capacity, Runnable onContentsChanged) {
        this(capacity, capacity, capacity, onContentsChanged);
    }

    public BaseEnergyStorage(long capacity, long maxReceive, long maxExtract, Runnable onContentsChanged) {
        this(capacity, maxReceive, maxExtract, 0L, onContentsChanged);
    }

    public BaseEnergyStorage(long capacity, long maxReceive, long maxExtract, long energy, Runnable onContentsChanged) {
        this.capacity = capacity;
        this.maxInsert = maxReceive;
        this.maxExtract = maxExtract;
        this.onContentsChanged = onContentsChanged;
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    public boolean supportsInsertion() {
        return this.maxInsert > 0L;
    }

    public long insert(long maxAmount, TransactionContext tx) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min(this.maxInsert, Math.min(maxAmount, this.capacity - this.amount));
        if (inserted > 0L) {
            this.updateSnapshots(tx);
            this.amount += inserted;
            if (inserted != 0L && this.onContentsChanged != null) {
                TransactionCallback.onSuccess((TransactionContext)tx, (Runnable)this.onContentsChanged);
            }
            return inserted;
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public long extract(long maxAmount, TransactionContext tx) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min(this.maxExtract, Math.min(maxAmount, this.amount));
        if (extracted > 0L) {
            this.updateSnapshots(tx);
            this.amount -= extracted;
            if (extracted != 0L && this.onContentsChanged != null) {
                TransactionCallback.onSuccess((TransactionContext)tx, (Runnable)this.onContentsChanged);
            }
            return extracted;
        }
        return 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setEnergyStored(long energy) {
        this.amount = energy;
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }
}

