/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import io.github.fabricators_of_create.porting_lib.level.LevelHooks;
import io.github.fabricators_of_create.porting_lib.level.events.BlockEvent;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public final class BlockHelper {
    public static class_3965 rayTraceBlocks(class_1937 level, class_1657 player) {
        return BlockHelper.rayTraceBlocks(level, player, class_3959.class_242.field_1348);
    }

    public static class_3965 rayTraceBlocks(class_1937 level, class_1657 player, class_3959.class_242 fluidMode) {
        class_1324 attribute = player.method_5996(class_5134.field_47758);
        double reach = attribute != null ? attribute.method_6194() : 4.5;
        return BlockHelper.rayTraceBlocks(level, player, reach, fluidMode);
    }

    private static class_3965 rayTraceBlocks(class_1937 level, class_1657 player, double reach, class_3959.class_242 fluidMode) {
        float pitch = player.method_36455();
        float yaw = player.method_36454();
        class_243 eyePos = player.method_5836(1.0f);
        float f2 = class_3532.method_15362((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = class_3532.method_15374((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -class_3532.method_15362((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        class_243 vec3d1 = eyePos.method_1031((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.method_17742(new class_3959(eyePos, vec3d1, class_3959.class_3960.field_17559, fluidMode, (class_1297)player));
    }

    public static boolean harvestBlock(class_1799 stack, class_1937 level, class_3222 player, class_2338 pos) {
        return BlockHelper.harvestBlock(stack, level, player, pos, true);
    }

    public static boolean harvestBlock(class_1799 stack, class_1937 level, class_3222 player, class_2338 pos, boolean playEvent) {
        class_2680 state;
        if (level.method_8608()) {
            return true;
        }
        class_1934 type = player.field_13974.method_14257();
        BlockEvent.BreakEvent event = LevelHooks.fireBlockBreak((class_1937)level, (class_1934)type, (class_3222)player, (class_2338)pos, (class_2680)(state = level.method_8320(pos)));
        if (event.isCanceled()) {
            return false;
        }
        if (player.method_21701(level, pos, type)) {
            return false;
        }
        if (playEvent) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
        boolean destroyed = BlockHelper.destroyBlock(state, level, (class_1657)player, pos);
        if (player.method_7337()) {
            return true;
        }
        class_2248 block = state.method_26204();
        if (destroyed && Cucumber.canHarvestBlock(state, (class_1922)level, pos, (class_1657)player)) {
            block.method_9556(level, (class_1657)player, pos, state, level.method_8321(pos), stack);
            stack.method_7952(level, state, pos, (class_1657)player);
        }
        class_2586 tile = level.method_8321(pos);
        int exp = LevelHooks.getExpDrop((class_2680)state, (class_1936)level, (class_2338)pos, (class_2586)tile, (class_1297)player, (class_1799)stack);
        if (destroyed && exp > 0) {
            block.method_9583(player.method_51469(), pos, exp);
        }
        return true;
    }

    public static boolean harvestAOEBlock(class_1799 stack, class_1937 level, class_3222 player, class_2338 pos) {
        if (BlockHelper.harvestBlock(stack, level, player, pos, false)) {
            player.field_13987.method_14364((class_2596)new class_2626((class_1922)level, pos));
            return true;
        }
        return false;
    }

    public static boolean destroyBlock(class_2680 state, class_1937 level, class_1657 player, class_2338 pos) {
        boolean canHarvest = !player.method_7337() && Cucumber.canHarvestBlock(state, (class_1922)level, pos, player);
        boolean destroyed = state.port_lib$onDestroyedByPlayer(level, pos, player, canHarvest, level.method_8316(pos));
        if (destroyed) {
            state.method_26204().method_9585((class_1936)level, pos, state);
        }
        return destroyed;
    }

    public static int getRedstoneSignalFromInventory(@Nullable class_2586 entity) {
        if (entity instanceof BaseInventoryTileEntity) {
            BaseInventoryTileEntity tile = (BaseInventoryTileEntity)entity;
            BaseItemStackHandler inventory = tile.getInventory();
            float f = 0.0f;
            for (int i = 0; i < inventory.getSlotCount(); ++i) {
                class_1799 stack = inventory.getStackInSlot(i);
                if (stack.method_7960()) continue;
                f += (float)stack.method_7947() / (float)inventory.getStackLimit(i, ItemVariant.of((class_1799)stack), stack.method_7947());
            }
            return class_3532.method_53063((float)(f /= (float)inventory.getSlotCount()), (int)0, (int)15);
        }
        return 0;
    }
}

