/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.event.RecipeManagerLoadedEvent;
import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class RecipeHelper {
    @Nullable
    private static WeakReference<class_1863> recipeManager;

    public static class_1863 getRecipeManager() throws IllegalStateException {
        if (recipeManager == null || recipeManager.get() == null) {
            throw new IllegalStateException("Recipe Manager is not available");
        }
        return (class_1863)recipeManager.get();
    }

    @ApiStatus.Internal
    public static void setRecipeManager(class_1863 manager) {
        recipeManager = new WeakReference<class_1863>(manager);
    }

    public static <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> byType(class_3956<T> type) {
        return RecipeHelper.byType(RecipeHelper.getRecipeManager(), type);
    }

    public static <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> byType(class_1863 manager, class_3956<T> type) {
        return manager.method_17717(type);
    }

    public static <I extends class_9695, T extends class_1860<I>> List<T> byTypeValues(class_3956<T> type) {
        return RecipeHelper.byTypeValues(RecipeHelper.getRecipeManager(), type);
    }

    public static <I extends class_9695, T extends class_1860<I>> List<T> byTypeValues(class_1863 manager, class_3956<T> type) {
        return RecipeHelper.byType(manager, type).stream().map(class_8786::comp_1933).toList();
    }

    public static Collection<class_8786<?>> getAllRecipes() {
        return RecipeHelper.getRecipeManager().method_8126();
    }

    @ApiStatus.Internal
    public static void fireRecipeManagerLoadingEvent(class_1863 manager, ImmutableMultimap.Builder<class_3956<?>, class_8786<?>> map, ImmutableMap.Builder<class_2960, class_8786<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            new RecipeManagerLoadingEvent(manager, recipes).sendEvent();
        }
        catch (Exception e) {
            Cucumber.LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (class_8786<?> recipe : recipes) {
            map.put((Object)recipe.comp_1933().method_17716(), recipe);
            builder.put((Object)recipe.comp_1932(), recipe);
        }
        Cucumber.LOGGER.info("Registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    @ApiStatus.Internal
    public static void fireRecipeManagerLoadedEvent(class_1863 manager) {
        try {
            new RecipeManagerLoadedEvent(manager).sendEvent();
        }
        catch (Exception e) {
            Cucumber.LOGGER.error("An error occurred while firing RecipeManagerLoadedEvent", (Throwable)e);
        }
    }
}

