/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.crafting.ShapelessCraftingInput;
import com.blakebr0.cucumber.inventory.CanExtractFunction;
import com.blakebr0.cucumber.inventory.CanInsertFunction;
import com.blakebr0.cucumber.inventory.ItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.RecipeInventory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.core.util.INBTSerializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9326;
import net.minecraft.class_9694;

public class BaseItemStackHandler
extends ItemStackHandler
implements INBTSerializable<class_2487> {
    private static final Codec<class_1799> ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(builder -> builder.group((App)class_1799.field_47312.fieldOf("id").forGetter(class_1799::method_41409), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)builder, class_1799::new)));
    private final OnContentsChangedFunction onContentsChanged;
    private final Map<Integer, Integer> slotSizeMap;
    private CanInsertFunction canInsert = null;
    private CanExtractFunction canExtract = null;
    private int maxStackSize = 64;
    private int[] outputSlots = null;

    protected BaseItemStackHandler(int size, OnContentsChangedFunction onContentsChanged) {
        super(size);
        this.onContentsChanged = onContentsChanged;
        this.slotSizeMap = new HashMap<Integer, Integer>();
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.slotSizeMap.containsKey(slot) ? this.slotSizeMap.get(slot) : this.maxStackSize;
    }

    public boolean isItemValid(int slot, ItemVariant stack, int amount) {
        return this.canInsert == null || this.canInsert.apply(slot, stack, amount);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.apply(slot);
        }
    }

    public class_2487 serializeNBT(class_7225.class_7874 lookup) {
        class_2499 items = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            class_2487 item = new class_2487();
            item.method_10569("Slot", i);
            items.add((Object)((class_2520)ITEM_STACK_CODEC.encode((Object)stack, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)item).getOrThrow()));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)items);
        nbt.method_10569("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(class_7225.class_7874 lookup, class_2487 nbt) {
        int size = nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.size();
        this.setSize(Math.max(size, this.stacks.size()));
        class_2499 items = nbt.method_10554("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            class_2487 item = items.method_10602(i);
            int slot = item.method_10550("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ITEM_STACK_CODEC.parse((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)item).resultOrPartial(error -> Cucumber.LOGGER.error("Tried to load invalid item: '{}'", error)).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public void setDefaultSlotLimit(int size) {
        this.maxStackSize = size;
    }

    public void addSlotLimit(int slot, int size) {
        if (size > 64 && size % 64 != 0) {
            throw new IllegalArgumentException("Slot limits above 64 must be a multiple of 64");
        }
        this.slotSizeMap.put(slot, size);
    }

    public void setCanInsert(CanInsertFunction canInsert) {
        this.canInsert = canInsert;
    }

    public void setCanExtract(CanExtractFunction canExtract) {
        this.canExtract = canExtract;
    }

    public void setOutputSlots(int ... slots) {
        this.outputSlots = slots;
    }

    public RecipeInventory toRecipeInventory() {
        return this.toRecipeInventory(0, this.stacks.size());
    }

    public RecipeInventory toRecipeInventory(int start, int size) {
        return new RecipeInventory(this, start, size);
    }

    public class_9694 toCraftingInput(int width, int height) {
        return class_9694.method_59986((int)width, (int)height, (List)this.stacks);
    }

    public class_9694 toShapelessCraftingInput() {
        return new ShapelessCraftingInput((List<class_1799>)this.stacks);
    }

    public class_9694 toCraftingInput(int width, int height, int startIndex, int endIndex) {
        return class_9694.method_59986((int)width, (int)height, (List)this.stacks.subList(startIndex, endIndex));
    }

    public class_9694 toShapelessCraftingInput(int startIndex, int endIndex) {
        return new ShapelessCraftingInput(this.stacks.subList(startIndex, endIndex));
    }

    public BaseItemStackHandler copy() {
        BaseItemStackHandler newInventory = new BaseItemStackHandler(this.getSlotCount(), this.onContentsChanged);
        newInventory.setDefaultSlotLimit(this.maxStackSize);
        newInventory.setCanInsert(this.canInsert);
        newInventory.setCanExtract(this.canExtract);
        newInventory.setOutputSlots(this.outputSlots);
        this.slotSizeMap.forEach(newInventory::addSlotLimit);
        for (int i = 0; i < this.getSlotCount(); ++i) {
            class_1799 stack = this.getStackInSlot(i);
            newInventory.setStackInSlot(i, stack.method_7972());
        }
        return newInventory;
    }

    public static BaseItemStackHandler create(int size) {
        return BaseItemStackHandler.create(size, builder -> {});
    }

    public static BaseItemStackHandler create(int size, Consumer<BaseItemStackHandler> builder) {
        return BaseItemStackHandler.create(size, null, builder);
    }

    public static BaseItemStackHandler create(int size, OnContentsChangedFunction onContentsChanged, Consumer<BaseItemStackHandler> builder) {
        BaseItemStackHandler handler = new BaseItemStackHandler(size, onContentsChanged);
        builder.accept(handler);
        return handler;
    }
}

