/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class ItemStackHandler
extends SnapshotParticipant<class_1799[]>
implements SlottedStackStorage {
    protected class_2371<class_1799> stacks;
    protected SingleSlotStorage<ItemVariant>[] slots;

    public ItemStackHandler() {
        this(1);
    }

    protected class_1799[] createSnapshot() {
        return (class_1799[])this.stacks.stream().map(class_1799::method_7972).toArray(class_1799[]::new);
    }

    protected void readSnapshot(class_1799[] snapshot) {
        this.stacks = class_2371.method_10212((Object)class_1799.field_8037, (Object[])snapshot);
        this.slots = this.makeSlots();
    }

    public ItemStackHandler(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.slots = this.makeSlots();
    }

    public ItemStackHandler(class_2371<class_1799> stacks) {
        this.stacks = stacks;
        this.slots = this.makeSlots();
    }

    protected SingleSlotStorage<ItemVariant>[] makeSlots() {
        SingleSlotStorage[] slots = new SingleSlotStorage[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            slots[i] = new ItemStackHandlerSlot(i);
        }
        return slots;
    }

    public void setSize(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public int getSlotCount() {
        return this.stacks.size();
    }

    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.stacks.get(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        int amount = maxAmount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAmount;
        for (int i = 0; i < this.stacks.size(); ++i) {
            int slot = i;
            if (!this.isItemValid(i, resource, amount)) continue;
            class_1799 existing = (class_1799)this.stacks.get(i);
            int limit = this.getStackLimit(i, resource, amount);
            if (!existing.method_7960()) {
                if (!class_1799.method_31577((class_1799)resource.toStack(), (class_1799)existing)) continue;
                limit -= existing.method_7947();
            }
            if (limit <= 0) {
                return 0L;
            }
            boolean reachedLimit = amount > limit;
            this.updateSnapshots(transaction);
            if (existing.method_7960()) {
                this.stacks.set(i, (Object)(reachedLimit ? resource.toStack(limit) : resource.toStack(amount)));
            } else {
                existing.method_7933(reachedLimit ? limit : amount);
            }
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> this.onContentsChanged(slot));
            return reachedLimit ? (long)limit : (long)amount;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        for (int i = 0; i < this.stacks.size(); ++i) {
            int slot = i;
            class_1799 existing = (class_1799)this.stacks.get(i);
            if (existing.method_7960()) continue;
            int toExtract = Math.min((int)maxAmount, existing.method_7914());
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> this.onContentsChanged(slot));
            if (existing.method_7947() <= toExtract) {
                this.updateSnapshots(transaction);
                this.stacks.set(i, (Object)class_1799.field_8037);
                return existing.method_7947();
            }
            this.stacks.set(i, (Object)existing.method_46651(existing.method_7947() - toExtract));
            return existing.method_7947();
        }
        return 0L;
    }

    public int getSlotLimit(int slot) {
        return 99;
    }

    public int getStackLimit(int slot, ItemVariant variant, long amount) {
        return Math.min(this.getSlotLimit(slot), variant.toStack().method_7914());
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return null;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }

    public class ItemStackHandlerSlot
    implements SingleSlotStorage<ItemVariant> {
        private final int slot;

        public ItemStackHandlerSlot(int slot) {
            this.slot = slot;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            int amount = maxAmount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAmount;
            if (!ItemStackHandler.this.isItemValid(this.slot, resource, amount)) {
                return 0L;
            }
            class_1799 existing = (class_1799)ItemStackHandler.this.stacks.get(this.slot);
            int limit = ItemStackHandler.this.getSlotLimit(this.slot);
            if (!existing.method_7960()) {
                if (!class_1799.method_31577((class_1799)resource.toStack(), (class_1799)existing)) {
                    return 0L;
                }
                limit -= existing.method_7947();
            }
            if (limit <= 0) {
                return 0L;
            }
            boolean reachedLimit = amount > limit;
            ItemStackHandler.this.updateSnapshots(transaction);
            if (existing.method_7960()) {
                ItemStackHandler.this.stacks.set(this.slot, (Object)(reachedLimit ? resource.toStack(limit) : resource.toStack(amount)));
            } else {
                existing.method_7933(reachedLimit ? limit : amount);
            }
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> ItemStackHandler.this.onContentsChanged(this.slot));
            return reachedLimit ? (long)limit : (long)amount;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            class_1799 existing = (class_1799)ItemStackHandler.this.stacks.get(this.slot);
            if (existing.method_7960()) {
                return 0L;
            }
            int toExtract = Math.min((int)maxAmount, existing.method_7914());
            ItemStackHandler.this.updateSnapshots(transaction);
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> ItemStackHandler.this.onContentsChanged(this.slot));
            if (existing.method_7947() <= toExtract) {
                ItemStackHandler.this.stacks.set(this.slot, (Object)class_1799.field_8037);
                return existing.method_7947();
            }
            ItemStackHandler.this.stacks.set(this.slot, (Object)existing.method_46651(existing.method_7947() - toExtract));
            return toExtract;
        }

        public boolean isResourceBlank() {
            return ((class_1799)ItemStackHandler.this.stacks.get(this.slot)).method_7960();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)((class_1799)ItemStackHandler.this.stacks.get(this.slot)));
        }

        public long getAmount() {
            return ((class_1799)ItemStackHandler.this.stacks.get(this.slot)).method_7947();
        }

        public long getCapacity() {
            return ((class_1799)ItemStackHandler.this.stacks.get(this.slot)).method_7914();
        }
    }
}

