/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.init.ModDataComponentTypes;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.cucumber.util.WateringCanUtil;
import io.github.fabricators_of_create.porting_lib.item.extensions.UseFirstBehaviorItem;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_9331;

public class BaseWateringCanItem
extends BaseItem
implements UseFirstBehaviorItem {
    protected final int range;
    protected final double chance;

    public BaseWateringCanItem(int range, double chance) {
        this(range, chance, p -> p);
    }

    public BaseWateringCanItem(int range, double chance, Function<class_1792.class_1793, class_1792.class_1793> properties) {
        super(properties.compose(p -> p.method_7889(1).method_57349((class_9331)ModDataComponentTypes.WATERING_CAN_FILLED.get(), (Object)false)));
        this.range = range;
        this.chance = chance;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 200;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_3610 fluid;
        class_1799 stack = player.method_5998(hand);
        if (BaseWateringCanItem.isFilled(stack)) {
            return new class_1271(class_1269.field_5811, (Object)stack);
        }
        class_3965 trace = BaseWateringCanItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (trace.method_17783() != class_239.class_240.field_1332) {
            return new class_1271(class_1269.field_5811, (Object)stack);
        }
        class_2338 pos = trace.method_17777();
        class_2350 direction = trace.method_17780();
        if (level.method_8505(player, pos) && player.method_7343(pos.method_10093(direction), direction, stack) && (fluid = level.method_8316(pos)).method_15767(class_3486.field_15517)) {
            BaseWateringCanItem.setFilled(stack, true);
            player.method_5783(class_3417.field_15126, 1.0f, 1.0f);
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2350 direction;
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_1268 hand = context.method_20287();
        class_1799 stack = player.method_5998(hand);
        class_2338 pos = context.method_8037();
        if (!player.method_7343(pos.method_10093(direction = context.method_8038()), direction, stack)) {
            return class_1269.field_5814;
        }
        if (!BaseWateringCanItem.isFilled(stack)) {
            return class_1269.field_5811;
        }
        player.method_6019(hand);
        return class_1269.field_5811;
    }

    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1657 player = context.method_8036();
        if (player instanceof FakePlayer) {
            class_1937 level = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2350 direction = context.method_8038();
            return this.doWater(stack, level, player, pos, direction);
        }
        return class_1269.field_5811;
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingTicks) {
        if (remainingTicks >= 0 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_3965 trace = BaseWateringCanItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
            if (trace.method_17783() == class_239.class_240.field_1332) {
                this.doWater(stack, level, player, trace.method_17777(), trace.method_17780());
            } else {
                entity.method_6075();
            }
        } else {
            entity.method_6075();
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        if (BaseWateringCanItem.isFilled(stack)) {
            tooltip.add((class_2561)Tooltips.FILLED.build());
        } else {
            tooltip.add((class_2561)Tooltips.EMPTY.build());
        }
    }

    public static boolean isFilled(class_1799 stack) {
        return (Boolean)stack.method_57825((class_9331)ModDataComponentTypes.WATERING_CAN_FILLED.get(), (Object)false);
    }

    public static void setFilled(class_1799 stack, boolean filled) {
        stack.method_57379((class_9331)ModDataComponentTypes.WATERING_CAN_FILLED.get(), (Object)filled);
    }

    protected class_1269 doWater(class_1799 stack, class_1937 level, class_1657 player, class_2338 pos, class_2350 direction) {
        if (player == null) {
            return class_1269.field_5814;
        }
        if (!player.method_7343(pos.method_10093(direction), direction, stack)) {
            return class_1269.field_5814;
        }
        if (!BaseWateringCanItem.isFilled(stack)) {
            return class_1269.field_5814;
        }
        if (!this.allowFakePlayerWatering() && player instanceof FakePlayer) {
            return class_1269.field_5814;
        }
        if (!level.method_8608()) {
            class_1792 item;
            class_1796 cooldowns = player.method_7357();
            if (!cooldowns.method_7904(item = stack.method_7909())) {
                cooldowns.method_7906(item, BaseWateringCanItem.getThrottleTicks(player));
            } else {
                return class_1269.field_5814;
            }
        }
        int range = (this.range - 1) / 2;
        class_2338.method_20437((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range, range, range)).forEach(aoePos -> {
            int moisture;
            class_2680 aoeState = level.method_8320(aoePos);
            if (aoeState.method_26204() instanceof class_2344 && (moisture = ((Integer)aoeState.method_11654((class_2769)class_2344.field_11009)).intValue()) < 7) {
                level.method_8652(aoePos, (class_2680)aoeState.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7)), 3);
            }
        });
        class_5819 random = Utils.RANDOM;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.method_10069(x, 0, z).method_10263() + random.method_43057();
                double d1 = (double)pos.method_10069(x, 0, z).method_10264() + 1.0;
                double d2 = (float)pos.method_10069(x, 0, z).method_10260() + random.method_43057();
                class_2680 state = level.method_8320(pos);
                if (state.method_26225() || state.method_26204() instanceof class_2344) {
                    d1 += 0.3;
                }
                level.method_8406((class_2394)class_2398.field_11242, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        BaseWateringCanItem.startPlayingSound(player);
        if (!level.method_8608() && Math.random() <= this.chance) {
            class_2338.method_20437((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range, range, range)).forEach(aoePos -> {
                class_2680 state = level.method_8320(aoePos);
                class_2248 plantBlock = state.method_26204();
                if (plantBlock instanceof class_2256 || plantBlock == class_2246.field_10402 || plantBlock == class_2246.field_10528) {
                    state.method_26199((class_3218)level, aoePos, random);
                }
            });
            return class_1269.field_5814;
        }
        return class_1269.field_5814;
    }

    protected boolean allowFakePlayerWatering() {
        return true;
    }

    public static void startPlayingSound(class_1657 player) {
        if (player.method_37908().method_8608()) {
            WateringCanUtil.startPlayingSound(player);
        }
    }

    public static void stopPlayingSound(class_1657 player) {
        if (player.method_37908().method_8608()) {
            WateringCanUtil.stopPlayingSound(player);
        }
    }

    private static int getThrottleTicks(class_1657 player) {
        return player instanceof FakePlayer ? 10 : 5;
    }
}

