/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import net.xiaoyu.dragon_wings.WingsRenderUtils;

@Mod.EventBusSubscriber(modid="dragon_wings")
public class WingRenderer
extends ModelBase {
    private static WingRenderer instance;
    private final ModelRenderer wing;
    private final ModelRenderer wingTip;

    private WingRenderer() {
        this.field_78090_t = 30;
        this.field_78089_u = 30;
        this.wing = new ModelRenderer((ModelBase)this, 0, 0);
        this.wing.func_78789_a(-10.0f, -1.0f, -1.0f, 10, 2, 2);
        this.wing.func_78793_a(-2.0f, 0.0f, 0.0f);
        ModelRenderer wingMembrane = new ModelRenderer((ModelBase)this, -10, 8);
        wingMembrane.func_78789_a(-10.0f, 0.0f, 0.5f, 10, 0, 10);
        wingMembrane.func_78793_a(0.0f, 0.0f, 0.0f);
        this.wing.func_78792_a(wingMembrane);
        this.wingTip = new ModelRenderer((ModelBase)this, 0, 5);
        this.wingTip.func_78789_a(-10.0f, -0.5f, -0.5f, 10, 1, 1);
        this.wingTip.func_78793_a(-10.0f, 0.0f, 0.0f);
        this.wing.func_78792_a(this.wingTip);
        ModelRenderer wingTipMembrane = new ModelRenderer((ModelBase)this, -10, 18);
        wingTipMembrane.func_78789_a(-10.0f, 0.0f, 0.5f, 10, 0, 10);
        wingTipMembrane.func_78793_a(0.0f, 0.0f, 0.0f);
        this.wingTip.func_78792_a(wingTipMembrane);
    }

    public static WingRenderer getInstance() {
        if (instance == null) {
            instance = new WingRenderer();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        WingType wingType = WingsRenderUtils.getWingTypeToRender(player);
        if (wingType != null) {
            WingRenderer.renderWings(player, event.getRenderer(), event.getX(), event.getY(), event.getZ(), event.getPartialRenderTick(), wingType);
        }
    }

    public static void renderWings(EntityPlayer player, RenderPlayer renderer, double x, double y, double z, float partialTicks, WingType wingType) {
        WingRenderer model = WingRenderer.getInstance();
        int scale = Config.getWingsScale(wingType);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        WingsRenderUtils.applyWingTransforms(player, scale);
        ResourceLocation texture = new ResourceLocation("dragon_wings", wingType.getTexturePath());
        renderer.func_110776_a(texture);
        model.updateWingAnimation();
        for (int j = 0; j < 2; ++j) {
            model.wing.func_78785_a(0.0625f);
            if (j != 0) continue;
            GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        }
        WingsRenderUtils.restoreWingTransforms();
        GlStateManager.func_179121_F();
    }

    private void updateWingAnimation() {
        float f11 = (float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f;
        this.wing.field_78795_f = (float)Math.toRadians(-80.0) - (float)Math.cos(f11) * 0.2f;
        this.wing.field_78796_g = (float)Math.toRadians(20.0) + (float)Math.sin(f11) * 0.4f;
        this.wing.field_78808_h = (float)Math.toRadians(20.0);
        this.wingTip.field_78808_h = -((float)(Math.sin(f11 + 2.0f) + 0.5)) * 0.75f;
    }
}

