/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import org.lwjgl.opengl.GL11;

public class WingsRenderUtils {
    public static boolean shouldRenderWings(EntityPlayer player, boolean enabled, boolean flyingExpand) {
        if (enabled) {
            return true;
        }
        return player.field_71075_bZ.field_75100_b && flyingExpand;
    }

    public static void applyWingTransforms(EntityPlayer player, int scale) {
        double scaleValue = (double)scale / 100.0;
        GL11.glPushMatrix();
        GL11.glScalef((float)((float)(-scaleValue)), (float)((float)(-scaleValue)), (float)((float)scaleValue));
        GL11.glRotatef((float)(180.0f + player.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-1.25f / (float)scaleValue), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.2f / (float)scaleValue));
        if (player.func_70093_af()) {
            GL11.glTranslatef((float)0.0f, (float)(0.125f / (float)scaleValue), (float)0.0f);
        }
    }

    public static void restoreWingTransforms() {
        GL11.glPopMatrix();
    }

    public static boolean isLocalPlayer(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        return player.equals((Object)mc.field_71439_g);
    }

    public static WingType getWingTypeToRender(EntityPlayer player) {
        if (player.func_82150_aj()) {
            return null;
        }
        boolean isLocalPlayer = WingsRenderUtils.isLocalPlayer(player);
        for (WingType wingType : WingType.values()) {
            boolean shouldRender;
            if (isLocalPlayer) {
                shouldRender = WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            } else {
                boolean bl = shouldRender = Config.showOtherPlayersWings(wingType) && WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            }
            if (!shouldRender) continue;
            return wingType;
        }
        return null;
    }
}

