/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import net.xiaoyu.dragon_wings.WingsRenderUtils;

@Mod.EventBusSubscriber(modid="dragon_wings")
public class WingRenderer {
    private static WingRenderer instance;
    private final ModelPart wing;
    private final ModelPart wingTip;

    private WingRenderer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wingPart = partdefinition.m_171599_("wing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f).m_171514_(-10, 8).m_171481_(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        wingPart.m_171599_("wingtip", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-10.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f).m_171514_(-10, 18).m_171481_(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f), PartPose.m_171419_((float)-10.0f, (float)0.0f, (float)0.0f));
        ModelPart root = partdefinition.m_171583_(30, 30);
        this.wing = root.m_171324_("wing");
        this.wingTip = this.wing.m_171324_("wingtip");
    }

    public static WingRenderer getInstance() {
        if (instance == null) {
            instance = new WingRenderer();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        WingType wingType = WingsRenderUtils.getWingTypeToRender(player);
        if (wingType != null) {
            WingRenderer.renderWings(player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), wingType);
        }
    }

    public static void renderWings(Player player, PoseStack poseStack, MultiBufferSource buffer, int packedLight, WingType wingType) {
        WingRenderer renderer = WingRenderer.getInstance();
        int scale = Config.getWingsScale(wingType);
        WingsRenderUtils.applyWingTransforms(poseStack, player, scale);
        ResourceLocation texture = new ResourceLocation("dragon_wings", wingType.getTexturePath());
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        renderer.updateWingAnimation();
        for (int j = 0; j < 2; ++j) {
            renderer.wing.m_104301_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_);
            if (j != 0) continue;
            poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
        }
        WingsRenderUtils.restoreWingTransforms(poseStack);
    }

    private void updateWingAnimation() {
        float f11 = (float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f;
        this.wing.f_104203_ = (float)Math.toRadians(-80.0) - (float)Math.cos(f11) * 0.2f;
        this.wing.f_104204_ = (float)Math.toRadians(20.0) + (float)Math.sin(f11) * 0.4f;
        this.wing.f_104205_ = (float)Math.toRadians(20.0);
        this.wingTip.f_104205_ = -((float)(Math.sin(f11 + 2.0f) + 0.5)) * 0.75f;
    }
}

