/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;

public class WingsRenderUtils {
    public static boolean shouldRenderWings(Player player, boolean enabled, boolean flyingExpand) {
        if (enabled) {
            return true;
        }
        return player.m_150110_().f_35935_ && flyingExpand;
    }

    public static void applyWingTransforms(PoseStack poseStack, Player player, int scale) {
        double scaleValue = (double)scale / 100.0;
        poseStack.m_85836_();
        poseStack.m_85841_((float)(-scaleValue), (float)(-scaleValue), (float)scaleValue);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f + player.f_20883_));
        poseStack.m_85837_(0.0, -1.25 / scaleValue, 0.0);
        poseStack.m_85837_(0.0, 0.0, 0.2 / scaleValue);
        if (player.m_6047_()) {
            poseStack.m_85837_(0.0, 0.125 / scaleValue, 0.0);
        }
    }

    public static void restoreWingTransforms(PoseStack poseStack) {
        poseStack.m_85849_();
    }

    public static boolean isLocalPlayer(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        return player.equals((Object)mc.f_91074_);
    }

    public static WingType getWingTypeToRender(Player player) {
        if (player.m_20145_()) {
            return null;
        }
        boolean isLocalPlayer = WingsRenderUtils.isLocalPlayer(player);
        for (WingType wingType : WingType.values()) {
            boolean shouldRender;
            if (isLocalPlayer) {
                shouldRender = WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            } else {
                boolean bl = shouldRender = Config.showOtherPlayersWings(wingType) && WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            }
            if (!shouldRender) continue;
            return wingType;
        }
        return null;
    }
}

