/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.xiaoyu.dragon_wings.WingType;

public class Config {
    public static ModConfigSpec configSpec;
    private static final WingType[] WING_TYPES;
    public static ModConfigSpec.BooleanValue[] WINGS_ENABLED;
    public static ModConfigSpec.IntValue[] WINGS_SCALE;
    public static ModConfigSpec.BooleanValue[] WINGS_FLYING_EXPAND;
    public static ModConfigSpec.BooleanValue[] SHOW_OTHER_PLAYERS_WINGS;

    public static void registerConfig(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configSpec);
    }

    public static boolean isWingsEnabled(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_ENABLED.length) {
            return (Boolean)WINGS_ENABLED[index].get();
        }
        return true;
    }

    public static int getWingsScale(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_SCALE.length) {
            return (Integer)WINGS_SCALE[index].get();
        }
        return 100;
    }

    public static boolean isWingsFlyingExpand(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_FLYING_EXPAND.length) {
            return (Boolean)WINGS_FLYING_EXPAND[index].get();
        }
        return true;
    }

    public static boolean showOtherPlayersWings(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < SHOW_OTHER_PLAYERS_WINGS.length) {
            return (Boolean)SHOW_OTHER_PLAYERS_WINGS[index].get();
        }
        return true;
    }

    static {
        WING_TYPES = WingType.values();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        WINGS_ENABLED = new ModConfigSpec.BooleanValue[WING_TYPES.length];
        WINGS_SCALE = new ModConfigSpec.IntValue[WING_TYPES.length];
        WINGS_FLYING_EXPAND = new ModConfigSpec.BooleanValue[WING_TYPES.length];
        SHOW_OTHER_PLAYERS_WINGS = new ModConfigSpec.BooleanValue[WING_TYPES.length];
        for (int i = 0; i < WING_TYPES.length; ++i) {
            WingType wingType = WING_TYPES[i];
            builder.push(wingType.getDisplayName() + " Settings");
            Config.WINGS_ENABLED[i] = builder.comment("Enable or disable the " + wingType.getDisplayName().toLowerCase() + " rendering").define(wingType.getEnabledConfigKey(), i == 0);
            Config.WINGS_SCALE[i] = builder.comment("Scale of the " + wingType.getDisplayName().toLowerCase()).defineInRange(wingType.getScaleConfigKey(), 100, 1, Integer.MAX_VALUE);
            Config.WINGS_FLYING_EXPAND[i] = builder.comment("Whether to expand wings when flying for " + wingType.getDisplayName().toLowerCase()).define(wingType.getFlyingExpandConfigKey(), false);
            Config.SHOW_OTHER_PLAYERS_WINGS[i] = builder.comment("Whether to show " + wingType.getDisplayName().toLowerCase() + " on other players").define(wingType.getDisplayName().toLowerCase().replace(" ", "_") + "_show_other_players_wings", false);
            builder.pop();
        }
        configSpec = builder.build();
    }
}

