/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import net.xiaoyu.dragon_wings.WingsRenderUtils;

@EventBusSubscriber(modid="dragon_wings")
public class WingRenderer {
    private static WingRenderer instance;
    private final ModelPart wing;
    private final ModelPart wingTip;

    private WingRenderer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wingPart = partdefinition.addOrReplaceChild("wing", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f).texOffs(-10, 8).addBox(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        wingPart.addOrReplaceChild("wingtip", CubeListBuilder.create().texOffs(0, 5).addBox(-10.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f).texOffs(-10, 18).addBox(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f), PartPose.offset((float)-10.0f, (float)0.0f, (float)0.0f));
        ModelPart root = partdefinition.bake(30, 30);
        this.wing = root.getChild("wing");
        this.wingTip = this.wing.getChild("wingtip");
    }

    public static WingRenderer getInstance() {
        if (instance == null) {
            instance = new WingRenderer();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        int entityId = ((PlayerRenderState)event.getRenderState()).id;
        Player player = (Player)Minecraft.getInstance().level.getEntity(entityId);
        WingType wingType = WingsRenderUtils.getWingTypeToRender(player);
        if (wingType != null) {
            WingRenderer.renderWings(player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), wingType);
        }
    }

    public static void renderWings(Player player, PoseStack poseStack, MultiBufferSource buffer, int packedLight, WingType wingType) {
        WingRenderer renderer = WingRenderer.getInstance();
        int scale = Config.getWingsScale(wingType);
        WingsRenderUtils.applyWingTransforms(poseStack, player, scale);
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"dragon_wings", (String)wingType.getTexturePath());
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
        renderer.updateWingAnimation();
        for (int j = 0; j < 2; ++j) {
            renderer.wing.render(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            if (j != 0) continue;
            poseStack.scale(-1.0f, 1.0f, 1.0f);
        }
        WingsRenderUtils.restoreWingTransforms(poseStack);
    }

    private void updateWingAnimation() {
        float f11 = (float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f;
        this.wing.xRot = (float)Math.toRadians(-80.0) - (float)Math.cos(f11) * 0.2f;
        this.wing.yRot = (float)Math.toRadians(20.0) + (float)Math.sin(f11) * 0.4f;
        this.wing.zRot = (float)Math.toRadians(20.0);
        this.wingTip.zRot = -((float)(Math.sin(f11 + 2.0f) + 0.5)) * 0.75f;
    }
}

