/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import org.joml.Quaternionfc;

public class WingsRenderUtils {
    public static boolean shouldRenderWings(Player player, boolean enabled, boolean flyingExpand) {
        if (enabled) {
            return true;
        }
        return player.getAbilities().flying && flyingExpand;
    }

    public static void applyWingTransforms(PoseStack poseStack, Player player, int scale) {
        double scaleValue = (double)scale / 100.0;
        poseStack.pushPose();
        poseStack.scale((float)(-scaleValue), (float)(-scaleValue), (float)scaleValue);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f + player.yBodyRot));
        poseStack.translate(0.0, -1.25 / scaleValue, 0.0);
        poseStack.translate(0.0, 0.0, 0.2 / scaleValue);
        if (player.isCrouching()) {
            poseStack.translate(0.0, 0.125 / scaleValue, 0.0);
        }
    }

    public static void restoreWingTransforms(PoseStack poseStack) {
        poseStack.popPose();
    }

    public static boolean isLocalPlayer(Player player) {
        Minecraft mc = Minecraft.getInstance();
        return player.equals((Object)mc.player);
    }

    public static WingType getWingTypeToRender(Player player) {
        if (player.isInvisible()) {
            return null;
        }
        boolean isLocalPlayer = WingsRenderUtils.isLocalPlayer(player);
        for (WingType wingType : WingType.values()) {
            boolean shouldRender;
            if (isLocalPlayer) {
                shouldRender = WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            } else {
                boolean bl = shouldRender = Config.showOtherPlayersWings(wingType) && WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            }
            if (!shouldRender) continue;
            return wingType;
        }
        return null;
    }
}

