/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.xiaoyu.dragon_wings.WingType;

public class Config {
    public static ForgeConfigSpec configSpec;
    private static final WingType[] WING_TYPES;
    public static ForgeConfigSpec.BooleanValue[] WINGS_ENABLED;
    public static ForgeConfigSpec.IntValue[] WINGS_SCALE;
    public static ForgeConfigSpec.BooleanValue[] WINGS_FLYING_EXPAND;
    public static ForgeConfigSpec.BooleanValue[] SHOW_OTHER_PLAYERS_WINGS;

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, configSpec);
    }

    public static boolean isWingsEnabled(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_ENABLED.length) {
            return (Boolean)WINGS_ENABLED[index].get();
        }
        return true;
    }

    public static int getWingsScale(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_SCALE.length) {
            return (Integer)WINGS_SCALE[index].get();
        }
        return 100;
    }

    public static boolean isWingsFlyingExpand(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < WINGS_FLYING_EXPAND.length) {
            return (Boolean)WINGS_FLYING_EXPAND[index].get();
        }
        return true;
    }

    public static boolean showOtherPlayersWings(WingType wingType) {
        int index = wingType.ordinal();
        if (index >= 0 && index < SHOW_OTHER_PLAYERS_WINGS.length) {
            return (Boolean)SHOW_OTHER_PLAYERS_WINGS[index].get();
        }
        return true;
    }

    static {
        WING_TYPES = WingType.values();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        WINGS_ENABLED = new ForgeConfigSpec.BooleanValue[WING_TYPES.length];
        WINGS_SCALE = new ForgeConfigSpec.IntValue[WING_TYPES.length];
        WINGS_FLYING_EXPAND = new ForgeConfigSpec.BooleanValue[WING_TYPES.length];
        SHOW_OTHER_PLAYERS_WINGS = new ForgeConfigSpec.BooleanValue[WING_TYPES.length];
        for (int i = 0; i < WING_TYPES.length; ++i) {
            WingType wingType = WING_TYPES[i];
            builder.push(wingType.getDisplayName() + " Settings");
            Config.WINGS_ENABLED[i] = builder.comment("Enable or disable the " + wingType.getDisplayName().toLowerCase() + " rendering").define(wingType.getEnabledConfigKey(), i == 0);
            Config.WINGS_SCALE[i] = builder.comment("Scale of the " + wingType.getDisplayName().toLowerCase()).defineInRange(wingType.getScaleConfigKey(), 100, 1, Integer.MAX_VALUE);
            Config.WINGS_FLYING_EXPAND[i] = builder.comment("Whether to expand wings when flying for " + wingType.getDisplayName().toLowerCase()).define(wingType.getFlyingExpandConfigKey(), false);
            Config.SHOW_OTHER_PLAYERS_WINGS[i] = builder.comment("Whether to show " + wingType.getDisplayName().toLowerCase() + " on other players").define(wingType.getDisplayName().toLowerCase().replace(" ", "_") + "_show_other_players_wings", false);
            builder.pop();
        }
        configSpec = builder.build();
    }
}

