/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;
import net.xiaoyu.dragon_wings.WingsRenderUtils;

@Mod.EventBusSubscriber(modid="dragon_wings")
public class WingRenderer {
    private static WingRenderer instance;
    private final ModelRenderer wing = new ModelRenderer(30, 30, 0, 0);
    private final ModelRenderer wingTip;

    private WingRenderer() {
        this.wing.func_228300_a_(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f);
        this.wing.func_78793_a(-2.0f, 0.0f, 0.0f);
        ModelRenderer wingMembrane = new ModelRenderer(30, 30, -10, 8);
        wingMembrane.func_228300_a_(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f);
        wingMembrane.func_78793_a(0.0f, 0.0f, 0.0f);
        this.wing.func_78792_a(wingMembrane);
        this.wingTip = new ModelRenderer(30, 30, 0, 5);
        this.wingTip.func_228300_a_(-10.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f);
        this.wingTip.func_78793_a(-10.0f, 0.0f, 0.0f);
        this.wing.func_78792_a(this.wingTip);
        ModelRenderer wingTipMembrane = new ModelRenderer(30, 30, -10, 18);
        wingTipMembrane.func_228300_a_(-10.0f, 0.0f, 0.5f, 10.0f, 0.0f, 10.0f);
        wingTipMembrane.func_78793_a(0.0f, 0.0f, 0.0f);
        this.wingTip.func_78792_a(wingTipMembrane);
    }

    public static WingRenderer getInstance() {
        if (instance == null) {
            instance = new WingRenderer();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        PlayerEntity player;
        WingType wingType;
        if (event.getPlayer() instanceof PlayerEntity && (wingType = WingsRenderUtils.getWingTypeToRender(player = event.getPlayer())) != null) {
            WingRenderer.renderWings(player, event.getMatrixStack(), event.getBuffers(), event.getLight(), wingType);
        }
    }

    public static void renderWings(PlayerEntity player, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, WingType wingType) {
        WingRenderer renderer = WingRenderer.getInstance();
        int scale = Config.getWingsScale(wingType);
        WingsRenderUtils.applyWingTransforms(matrixStack, player, scale);
        ResourceLocation texture = new ResourceLocation("dragon_wings", wingType.getTexturePath());
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture));
        renderer.updateWingAnimation();
        for (int j = 0; j < 2; ++j) {
            renderer.wing.func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
            if (j != 0) continue;
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
        }
        WingsRenderUtils.restoreWingTransforms(matrixStack);
    }

    private void updateWingAnimation() {
        float f11 = (float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f;
        this.wing.field_78795_f = (float)Math.toRadians(-80.0) - (float)Math.cos(f11) * 0.2f;
        this.wing.field_78796_g = (float)Math.toRadians(20.0) + (float)Math.sin(f11) * 0.4f;
        this.wing.field_78808_h = (float)Math.toRadians(20.0);
        this.wingTip.field_78808_h = -((float)(Math.sin(f11 + 2.0f) + 0.5)) * 0.75f;
    }
}

