/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.dragon_wings;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.xiaoyu.dragon_wings.Config;
import net.xiaoyu.dragon_wings.WingType;

public class WingsRenderUtils {
    public static boolean shouldRenderWings(PlayerEntity player, boolean enabled, boolean flyingExpand) {
        if (enabled) {
            return true;
        }
        return player.field_71075_bZ.field_75100_b && flyingExpand;
    }

    public static void applyWingTransforms(MatrixStack matrixStack, PlayerEntity player, int scale) {
        double scaleValue = (double)scale / 100.0;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_((float)(-scaleValue), (float)(-scaleValue), (float)scaleValue);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + player.field_70761_aq));
        matrixStack.func_227861_a_(0.0, -1.25 / scaleValue, 0.0);
        matrixStack.func_227861_a_(0.0, 0.0, 0.2 / scaleValue);
        if (player.func_213453_ef()) {
            matrixStack.func_227861_a_(0.0, 0.125 / scaleValue, 0.0);
        }
    }

    public static void restoreWingTransforms(MatrixStack matrixStack) {
        matrixStack.func_227865_b_();
    }

    public static boolean isLocalPlayer(PlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        return player.equals((Object)mc.field_71439_g);
    }

    public static WingType getWingTypeToRender(PlayerEntity player) {
        if (player.func_82150_aj()) {
            return null;
        }
        boolean isLocalPlayer = WingsRenderUtils.isLocalPlayer(player);
        for (WingType wingType : WingType.values()) {
            boolean shouldRender;
            if (isLocalPlayer) {
                shouldRender = WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            } else {
                boolean bl = shouldRender = Config.showOtherPlayersWings(wingType) && WingsRenderUtils.shouldRenderWings(player, Config.isWingsEnabled(wingType), Config.isWingsFlyingExpand(wingType));
            }
            if (!shouldRender) continue;
            return wingType;
        }
        return null;
    }
}

