/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.extdrawpatch.impl.model;

import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BaseDrawerModel
extends BlockModel {
    private final ItemDisplayElement main;
    private final class_2754<class_2350> property;
    private final class_2754<class_2738> blockFace;

    public BaseDrawerModel(class_2680 state, class_2754<class_2350> directionProperty, class_2754<class_2738> blockFaceProperty) {
        this.property = directionProperty;
        this.blockFace = blockFaceProperty;
        this.main = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
        this.main.setScale((Vector3fc)new Vector3f(2.0f));
        this.addElement((VirtualElement)this.main);
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        super.notifyUpdate(updateType);
        if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
            this.updateState(this.blockState());
        }
    }

    protected void updateState(class_2680 state) {
        float yaw = ((class_2350)state.method_11654(this.property)).method_10144();
        int pitch = switch ((class_2738)state.method_11654(this.blockFace)) {
            default -> throw new MatchException(null, null);
            case class_2738.field_12475 -> -90;
            case class_2738.field_12473 -> 90;
            case class_2738.field_12471 -> 0;
        };
        this.setRotation(pitch, yaw);
        if (this.getAttachment() != null) {
            this.tick();
        }
    }

    protected void setRotation(float pitch, float yaw) {
        this.main.setYaw(yaw);
        this.main.setPitch(pitch);
    }

    public record DrawerIcon(boolean isSmall, class_241 offset, Vector2f rot, ItemDisplayElement mainItem, List<ItemDisplayElement> topIcons, TextDisplayElement count) {
        private static final Map<class_2960, class_1799> ICONS = new HashMap<class_2960, class_1799>();

        public static DrawerIcon create(BaseDrawerModel model, boolean isSmall, class_241 offset, Matrix4f mat) {
            DrawerIcon icon = new DrawerIcon(isSmall, offset, new Vector2f(), ItemDisplayElementUtil.createSimple(), new ArrayList<ItemDisplayElement>(), new TextDisplayElement((class_2561)class_2561.method_43470((String)"0")));
            ClientCategory.LayoutGroup conf = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().layout();
            icon.mainItem.setViewRange(0.4f);
            icon.mainItem.setItemDisplayContext(class_811.field_4317);
            icon.count.setViewRange(0.4f);
            icon.count.setBackground(0);
            icon.count.setInvisible(true);
            mat.identity();
            mat.translate(offset.field_1343, offset.field_1342, 0.51f);
            mat.scale(conf.textScale(isSmall));
            mat.translate(0.0f, -conf.textOffset() / 2.0f, 0.0f);
            mat.scale(0.5f);
            icon.count.setTransformation(mat);
            mat.identity();
            mat.translate(offset.field_1343, offset.field_1342, 0.505f);
            mat.rotateY((float)Math.PI);
            mat.scale(conf.itemScale(isSmall));
            mat.scale(0.5f, 0.5f, 0.008f);
            icon.mainItem.setTransformation(mat);
            model.addElement((VirtualElement)icon.mainItem);
            model.addElement((VirtualElement)icon.count);
            return icon;
        }

        public void updateSettingsPos(BaseDrawerModel model, List<class_1799> icons, Matrix4f mat) {
            if (icons.isEmpty() && this.topIcons.isEmpty()) {
                return;
            }
            boolean reposition = false;
            while (this.topIcons.size() > icons.size()) {
                reposition = true;
                model.removeElement((VirtualElement)this.topIcons.removeLast());
            }
            while (this.topIcons.size() < icons.size()) {
                reposition = true;
                ItemDisplayElement e = ItemDisplayElementUtil.createSimple();
                e.setItemDisplayContext(class_811.field_4317);
                e.setViewRange(0.4f);
                e.setPitch(this.rot.x);
                e.setYaw(this.rot.y);
                model.addElement((VirtualElement)e);
                this.topIcons.add(e);
            }
            for (int i = 0; i < icons.size(); ++i) {
                this.topIcons.get(i).setItem(icons.get(i));
            }
            if (reposition) {
                ClientCategory.LayoutGroup conf = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().layout();
                int size = this.topIcons.size();
                mat.identity();
                mat.translate(this.offset.field_1343, this.offset.field_1342, 0.505f);
                mat.rotateY((float)Math.PI);
                mat.scale(conf.textScale(this.isSmall));
                mat.translate(0.0f, 0.4f, 0.0f);
                mat.scale(0.2f, 0.2f, 0.01f);
                mat.translate((float)size / 2.0f - 0.5f, 0.0f, 0.0f);
                for (ItemDisplayElement e : this.topIcons) {
                    e.setTransformation(mat);
                    mat.translate(-1.0f, 0.0f, 0.0f);
                }
            }
        }

        public void setRotation(float pitch, float yaw) {
            this.mainItem.setPitch(pitch);
            this.mainItem.setYaw(yaw);
            this.count.setPitch(pitch);
            this.count.setYaw(yaw);
            this.rot.set(pitch, yaw);
            for (ItemDisplayElement e : this.topIcons) {
                e.setPitch(pitch);
                e.setYaw(yaw);
            }
        }

        public void updateStorage(BaseDrawerModel model, ItemVariant resource, long amount, DrawerStorage storage, Matrix4f mat) {
            ModifierAccess access;
            if (storage.isHidden()) {
                this.update(model, resource.toStack(), "", List.of(), mat);
                return;
            }
            ClientCategory.IconGroup config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().icons();
            ArrayList<class_1799> icons = new ArrayList<class_1799>();
            if (storage.isLocked()) {
                this.addIcon(icons, config.lockedIcon());
            }
            if (storage.isVoiding()) {
                this.addIcon(icons, config.voidingIcon());
            }
            if (storage.isHidden()) {
                this.addIcon(icons, config.hiddenIcon());
            }
            if (storage.isDuping()) {
                this.addIcon(icons, config.dupingIcon());
            }
            if (storage instanceof ModifierAccess && (access = (ModifierAccess)storage).getUpgrade() != null) {
                this.addIcon(icons, access.getUpgrade().sprite);
            }
            if (storage.hasLimiter()) {
                this.addIcon(icons, ExtendedDrawers.id((String)"item/limiter"));
            }
            this.update(model, resource.toStack(), storage.isDuping() ? "\u221e" : (amount != 0L || ((ConfigData)ExtendedDrawers.CONFIG.get()).client().displayEmptyCount() ? String.valueOf(amount) : ""), icons, mat);
        }

        public void update(BaseDrawerModel model, class_1799 itemStack, String count, List<class_1799> icons, Matrix4f mat) {
            this.mainItem.setItem(itemStack);
            this.count.setText((class_2561)class_2561.method_43470((String)count));
            this.updateSettingsPos(model, icons, mat);
        }

        private void addIcon(ArrayList<class_1799> icons, class_2960 id) {
            class_1799 val = ICONS.get(id);
            if (val == null) {
                class_2960 itemId = id;
                if (itemId.method_12832().startsWith("item/")) {
                    itemId = itemId.method_45134(x -> x.substring("item/".length()));
                } else if (itemId.method_12832().startsWith("block/")) {
                    itemId = itemId.method_45134(x -> x.substring("block/".length()));
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
                if (item == class_1802.field_8162) {
                    item = class_1802.field_8077;
                }
                val = item.method_7854();
                ICONS.put(id, val);
            }
            icons.add(val);
        }
    }
}

