package com.startraveler.everythingburns.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.startraveler.everythingburns.EverythingBurns;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2358.class)
public class FireBlockMixin {
    @ModifyReturnValue(at = @At("RETURN"), method = "getBurnOdds(Lnet/minecraft/world/level/block/state/BlockState;)I")
    private int modifyBurnOdds(int original, @Local(argsOnly = true) class_2680 state) {
        int result = original <= 0 && !state.method_26164(EverythingBurns.BURNING_NOT_MODIFIED) && state.method_26227()
                .method_15769() && !state.method_26215()  ? 30 : original;
        if (result > 0 && original <= 0 && EverythingBurns.doLogging) {
            EverythingBurns.LOGGER.info(
                    "Modifying burn odds for {} from {} to {}",
                    state,
                    original,
                    result
            );
        }
        return result;
    }

    @ModifyReturnValue(at = @At("RETURN"), method = "getIgniteOdds(Lnet/minecraft/world/level/block/state/BlockState;)I")
    private int modifyIgniteOdds(int original, @Local(argsOnly = true) class_2680 state) {

        int result = original <= 0 && !state.method_26164(EverythingBurns.BURNING_NOT_MODIFIED) && state.method_26227()
                .method_15769() && !state.method_26215() ? 60 : original;
        if (result > 0 && original <= 0 && EverythingBurns.doLogging) {
            EverythingBurns.LOGGER.info(
                    "Modifying ignite odds for {} from {} to {}",
                    state,
                    original,
                    result
            );
        }

        return result;
    }
}