/*
 * Decompiled with CFR 0.152.
 */
package settingdust.more_enchantment_info.jei;

import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import settingdust.more_enchantment_info.util.EnchantmentAdapter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J\u001d\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\f0\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J9\u0010\u0016\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00130\u0013 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00170\u00172\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lsettingdust/more_enchantment_info/jei/EnchantmentIngredientHelper;", "Lmezz/jei/api/ingredients/IIngredientHelper;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "<init>", "()V", "ENCHANTMENT_INGREDIENT", "Lmezz/jei/api/ingredients/IIngredientType;", "kotlin.jvm.PlatformType", "getENCHANTMENT_INGREDIENT", "()Lmezz/jei/api/ingredients/IIngredientType;", "getIngredientType", "getDisplayName", "", "ingredient", "(Lnet/minecraft/world/item/enchantment/Enchantment;)Ljava/lang/String;", "getUniqueId", "context", "Lmezz/jei/api/ingredients/subtypes/UidContext;", "getResourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "copyIngredient", "getErrorInfo", "getTagStream", "Ljava/util/stream/Stream;", "(Lnet/minecraft/world/item/enchantment/Enchantment;)Ljava/util/stream/Stream;", "getCheatItemStack", "Lnet/minecraft/world/item/ItemStack;", "more-enchantment-info_neoforge121"})
public final class EnchantmentIngredientHelper
implements IIngredientHelper<Enchantment> {
    @NotNull
    public static final EnchantmentIngredientHelper INSTANCE = new EnchantmentIngredientHelper();
    @NotNull
    private static final IIngredientType<Enchantment> ENCHANTMENT_INGREDIENT = EnchantmentIngredientHelper::ENCHANTMENT_INGREDIENT$lambda$0;

    private EnchantmentIngredientHelper() {
    }

    @NotNull
    public final IIngredientType<Enchantment> getENCHANTMENT_INGREDIENT() {
        return ENCHANTMENT_INGREDIENT;
    }

    @NotNull
    public IIngredientType<Enchantment> getIngredientType() {
        return ENCHANTMENT_INGREDIENT;
    }

    public String getDisplayName(@NotNull Enchantment ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return EnchantmentAdapter.Companion.getName(ingredient).getString();
    }

    @NotNull
    public String getUniqueId(@NotNull Enchantment ingredient, @NotNull UidContext context) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return "enchantment:" + EnchantmentAdapter.Companion.getKey(ingredient);
    }

    @Nullable
    public ResourceLocation getResourceLocation(@NotNull Enchantment ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return EnchantmentAdapter.Companion.getKey(ingredient);
    }

    @NotNull
    public Enchantment copyIngredient(@NotNull Enchantment ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return ingredient;
    }

    @NotNull
    public String getErrorInfo(@Nullable Enchantment ingredient) {
        Enchantment enchantment = ingredient;
        return String.valueOf(enchantment != null ? EnchantmentAdapter.Companion.getKey(enchantment) : null);
    }

    public Stream<ResourceLocation> getTagStream(@NotNull Enchantment ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Object object = EnchantmentAdapter.Companion.getHolder(ingredient);
        if (object == null || (object = object.tags()) == null || (object = object.map(arg_0 -> EnchantmentIngredientHelper.getTagStream$lambda$2(EnchantmentIngredientHelper::getTagStream$lambda$1, arg_0))) == null) {
            object = Stream.empty();
        }
        return object;
    }

    @NotNull
    public ItemStack getCheatItemStack(@NotNull Enchantment ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Holder<Enchantment> holder = EnchantmentAdapter.Companion.getHolder(ingredient);
        Intrinsics.checkNotNull(holder);
        ItemStack itemStack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)EnchantmentAdapter.Companion.EnchantmentInstance(holder, 1));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createForEnchantment(...)");
        return itemStack;
    }

    private static final Class ENCHANTMENT_INGREDIENT$lambda$0() {
        return Enchantment.class;
    }

    private static final ResourceLocation getTagStream$lambda$1(TagKey it) {
        return it.location();
    }

    private static final ResourceLocation getTagStream$lambda$2(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }
}

