/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.documentation.export.IJsonExportable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record DocCategory(ResourceLocation id, ItemStack renderIcon, int order, List<DocCategory> subCategories, Comparator<DocEntry> entryComparator, Set<DocCategory> parents) implements Comparable<DocCategory>,
IJsonExportable
{
    public DocCategory(ResourceLocation id, ItemStack renderIcon, int order) {
        this(id, renderIcon, order, new CopyOnWriteArrayList<DocCategory>(), Comparator.comparing(DocEntry::order).thenComparing(entry -> entry.entryTitle().getString()), ConcurrentHashMap.newKeySet());
    }

    public DocCategory withComparator(Comparator<DocEntry> comparator) {
        return new DocCategory(this.id, this.renderIcon, this.order, this.subCategories, comparator, ConcurrentHashMap.newKeySet());
    }

    public void addSubCategory(DocCategory category) {
        this.subCategories.add(category);
        category.parents.add(this);
    }

    public Component getTitle() {
        return Component.translatable((String)(this.id.getNamespace() + ".section." + this.id.getPath()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocCategory that = (DocCategory)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public int compareTo(@NotNull DocCategory o) {
        return this.order - o.order;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty(DocExporter.ID_PROPERTY, this.id.toString());
        object.addProperty(DocExporter.ORDER_PROPERTY, (Number)this.order);
        object.addProperty(DocExporter.TITLE_PROPERTY, this.getTitle().getString());
        return object;
    }
}

